/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.alinlib.config;

import com.google.gson.JsonObject;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_2561;
import net.minecraft.class_3518;
import org.apache.logging.log4j.Level;
import ru.kelcuprum.alinlib.AlinLib;

public class Localization {
    public static Parser defaultParser = s -> AlinLib.starScript.run(AlinLib.starScript.compile(s));
    private Parser parser = defaultParser;
    private static final int codes = 23;
    private static final Map<String, String> formatCodes = IntStream.range(0, 23).boxed().collect(Collectors.toMap(List.of("&4", "&c", "&6", "&e", "&z", "&a", "&b", "&3", "&1", "&9", "&d", "&5", "&f", "&7", "&8", "&0", "&r", "&l", "&o", "&n", "&m", "&k", "&x")::get, List.of("\u00a74", "\u00a7c", "\u00a76", "\u00a7e", "\u00a7z", "\u00a7a", "\u00a7b", "\u00a73", "\u00a71", "\u00a79", "\u00a7d", "\u00a75", "\u00a7f", "\u00a77", "\u00a78", "\u00a70", "\u00a7r", "\u00a7l", "\u00a7o", "\u00a7n", "\u00a7m", "\u00a7k", "\u00a7x")::get));
    public String modID;
    public String filePath;

    public Localization(String modID, String filePath) {
        this.modID = modID;
        this.filePath = filePath;
    }

    private String getCodeLocalization() {
        try {
            return AlinLib.MINECRAFT.field_1690.field_1883;
        }
        catch (Exception e) {
            return "en_us";
        }
    }

    public JsonObject getJSONFile() {
        try {
            Path localizationFile = Path.of(String.format("%s/%s.json", this.filePath, this.getCodeLocalization()), new String[0]);
            if (localizationFile.toFile().exists()) {
                return class_3518.method_15285((String)Files.readString(localizationFile));
            }
            return new JsonObject();
        }
        catch (Exception ex) {
            AlinLib.LOG.error(ex.getLocalizedMessage());
            return new JsonObject();
        }
    }

    public String getLocalization(String key) {
        return this.getLocalization(key, false);
    }

    public String getLocalization(String key, boolean clearColor) {
        return this.getLocalization(key, clearColor, true);
    }

    public String getLocalization(String key, boolean clearColor, boolean parse) {
        return this.getLocalization(key, clearColor, true, parse);
    }

    public String getLocalization(String key, boolean clearColor, boolean fixFormatCodes, boolean parse) {
        String text;
        try {
            JsonObject JSONLocalization = this.getJSONFile();
            text = !JSONLocalization.has(key) || JSONLocalization.get(key).isJsonNull() ? Localization.getText(this.modID + "." + key).getString() : JSONLocalization.get(key).getAsString();
        }
        catch (Exception ex) {
            AlinLib.LOG.error(ex.getLocalizedMessage());
            text = this.getDefaultLocalization(key);
        }
        text = clearColor ? Localization.clearFormatCodes(text) : (fixFormatCodes ? Localization.fixFormatCodes(text) : text);
        return parse ? this.getParsedText(text) : text;
    }

    public String getParsedText(String content) {
        if (this.parser == null) {
            return content;
        }
        return this.parser.parser(content);
    }

    public String getDefaultLocalization(String key) {
        return Localization.getText(this.modID + "." + key).getString();
    }

    public void resetLocalization(String key) {
        this.setLocalization(key, this.getDefaultLocalization(key));
    }

    public void setLocalization(String type, String text) {
        try {
            JsonObject JSONLocalization = this.getJSONFile();
            JSONLocalization.addProperty(type, text);
            Path localizationFile = Path.of(String.format("%s/%s.json", this.filePath, this.getCodeLocalization()), new String[0]);
            Files.createDirectories(localizationFile.getParent(), new FileAttribute[0]);
            Files.writeString(localizationFile, (CharSequence)JSONLocalization.toString(), new OpenOption[0]);
        }
        catch (Exception e) {
            AlinLib.LOG.error(e.getLocalizedMessage(), Level.ERROR);
        }
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    public static String getRounding(double number) {
        return String.valueOf(Localization.getRounding(number, false));
    }

    public static String getRounding(double number, boolean isToInt) {
        String value = String.valueOf(Localization.getDoubleRounding(number, isToInt));
        if (isToInt) {
            value = value.split("\\.")[0];
        }
        return value;
    }

    public static double getDoubleRounding(double number) {
        return Localization.getDoubleRounding(number, false);
    }

    public static double getDoubleRounding(double number, boolean isToInt) {
        return isToInt ? (double)((int)number) : Localization.round(number, 3);
    }

    public static class_2561 getText(String key) {
        return class_2561.method_43471((String)key);
    }

    public static String getStringText(String key) {
        return Localization.toString(Localization.getText(key));
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public static class_2561 toText(String text) {
        return class_2561.method_43470((String)text);
    }

    public static String toString(class_2561 text) {
        return text.getString();
    }

    public static String clearFormatCodes(String text) {
        return text.replaceAll("([\u00a7&][a-f0-9k-orz])", "").replaceAll("#[a-fA-F0-9]{6}", "");
    }

    public static String fixFormatCodes(String text) {
        for (String formatCode : formatCodes.keySet()) {
            text = text.replaceAll(formatCode, formatCodes.get(formatCode));
        }
        return text;
    }

    public static interface Parser {
        public String parser(String var1);
    }
}

