/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.alinlib;

import java.time.LocalDate;
import java.util.Random;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import org.meteordev.starscript.value.ValueMap;
import ru.kelcuprum.alinlib.AlinLogger;
import ru.kelcuprum.alinlib.CommonUtils;
import ru.kelcuprum.alinlib.api.KeyMappingHelper;
import ru.kelcuprum.alinlib.api.events.alinlib.AlinLibEvents;
import ru.kelcuprum.alinlib.api.events.alinlib.LocalizationEvents;
import ru.kelcuprum.alinlib.api.events.client.ClientLifecycleEvents;
import ru.kelcuprum.alinlib.api.events.client.ClientTickEvents;
import ru.kelcuprum.alinlib.api.events.client.GuiRenderEvents;
import ru.kelcuprum.alinlib.config.Config;
import ru.kelcuprum.alinlib.config.Localization;
import ru.kelcuprum.alinlib.config.parser.StarScript;
import ru.kelcuprum.alinlib.gui.GuiUtils;
import ru.kelcuprum.alinlib.gui.Icons;
import ru.kelcuprum.alinlib.gui.config.DesignScreen;
import ru.kelcuprum.alinlib.gui.styles.FlatStyle;
import ru.kelcuprum.alinlib.gui.styles.ModernStyle;
import ru.kelcuprum.alinlib.gui.styles.WMStyle;
import ru.kelcuprum.alinlib.gui.styles.WinStyle;
import ru.kelcuprum.alinlib.gui.toast.ToastBuilder;
import ru.kelcuprum.alinlib.info.World;
import ru.kelcuprum.alinlib.test.GUIRender;
import ru.kelcuprum.alinlib.utils.StealthManager;

public class AlinLib
implements ClientModInitializer {
    public static final String MODID = "alinlib";
    public static String VERSION = "alinlib";
    public static final AlinLogger LOG = new AlinLogger("AlinaLib");
    public static Config bariumConfig = new Config("config/AlinLib/config.json");
    public static Localization localization = new Localization("alinlib", "config/AlinLib/lang");
    public static class_310 MINECRAFT = class_310.method_1551();
    public static StarScript starScript;

    public static boolean isNotReleaseVersion() {
        return VERSION.split("-").length > 1 && (VERSION.contains("beta") || VERSION.contains("alpha") || VERSION.contains("dev") || VERSION.contains("rc"));
    }

    public static void init() {
        starScript = new StarScript();
        GuiUtils.registerStyle(new FlatStyle());
        GuiUtils.registerStyle(new ModernStyle());
        GuiUtils.registerStyle(new WinStyle());
        GuiUtils.registerStyle(new WMStyle());
        World.registerDefaultWorlds();
        StealthManager.registerDefault();
        class_304 toggleStealth = KeyMappingHelper.register(CommonUtils.getKeyMapping("alinlib.key.stealth", -1, MODID));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            assert (client.field_1724 != null);
            while (toggleStealth.method_1436()) {
                bariumConfig.setBoolean("STREAMER.STEALTH", !bariumConfig.getBoolean("STREAMER.STEALTH", false));
            }
        });
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            class_304 openConfig = KeyMappingHelper.register(CommonUtils.getKeyMapping("alinlib.key.config", 76, MODID));
            GuiRenderEvents.RENDER.register(new GUIRender());
            ClientTickEvents.END_CLIENT_TICK.register(client -> {
                assert (client.field_1724 != null);
                while (openConfig.method_1436()) {
                    MINECRAFT.method_1507(DesignScreen.build(AlinLib.MINECRAFT.field_1755));
                }
            });
        }
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            LocalizationEvents.DEFAULT_PARSER_INIT.invoker().onParserInit(starScript);
            LOG.log(String.format("Client started. MC Version: %s", client.method_1515()));
        });
        ClientLifecycleEvents.CLIENT_FULL_STARTED.register(client -> {
            LOG.log(String.format("Client full started. MC Version: %s", client.method_1515()));
            AlinLib.aprilFool();
            AlinLib.hbKel();
        });
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> {
            LOG.log((class_2561)class_2561.method_43471((String)"alinlib.log.exit.first"));
            LOG.log((class_2561)class_2561.method_43471((String)"alinlib.log.exit.two"));
        });
        LocalizationEvents.DEFAULT_PARSER_INIT.register(parser -> parser.ss.set(MODID, new ValueMap().set("id", MODID).set("version", VERSION)));
        AlinLibEvents.INIT.invoker().onInit();
    }

    public void onInitializeClient() {
        VERSION = ((ModContainer)FabricLoader.getInstance().getModContainer(MODID).get()).getMetadata().getVersion().getFriendlyString();
        AlinLib.init();
    }

    public static boolean isAprilFool() {
        return LocalDate.now().getMonthValue() == 4 && LocalDate.now().getDayOfMonth() == 1;
    }

    public static void aprilFool() {
        if (AlinLib.isAprilFool()) {
            String[] types = new String[]{"white", "welcome", "clownfish"};
            String type = types[new Random().nextInt(types.length)];
            new ToastBuilder().setIcon(Icons.CLOWNFISH).setTitle((class_2561)class_2561.method_43470((String)"AlinLib")).setMessage((class_2561)class_2561.method_43471((String)("alinlib.april_fools." + type))).setType(ToastBuilder.Type.WARN).buildAndShow();
        }
    }

    public static void hbKel() {
        if (AlinLib.isHBKel()) {
            if (bariumConfig.getBoolean("KEL_HB_" + LocalDate.now().getYear(), false)) {
                return;
            }
            bariumConfig.setBoolean("KEL_HB_" + LocalDate.now().getYear(), true);
            new ToastBuilder().setIcon(class_1802.field_17534).setTitle((class_2561)class_2561.method_43470((String)"AlinLib")).setMessage((class_2561)class_2561.method_43471((String)"alinlib.hb")).buildAndShow();
        }
    }

    public static boolean isHBKel() {
        return LocalDate.now().getMonthValue() == 4 && LocalDate.now().getDayOfMonth() == 8;
    }
}

