/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.alinlib.gui.components;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.gui.GuiUtils;

public class ConfigureScrolWidget
extends class_339 {
    private double scrollAmount;
    private boolean scrolling;
    public final Consumer<ConfigureScrolWidget> onScroll;
    public int innerHeight;
    public List<class_339> widgets = new ArrayList<class_339>();
    private double animationTimer = 0.0;
    private double scrollStartVelocity = 0.0;
    public static double scrollSpeed = 0.5;
    public static double scrollbarDrag = 0.025;
    public static double animationDuration = 1.0;
    public static double pushBackStrength = 1.0;

    public ConfigureScrolWidget(int x, int y, int width, int height, class_2561 message, Consumer<ConfigureScrolWidget> onScroll) {
        super(x, y, width, height, message);
        this.onScroll = onScroll;
    }

    protected int getInnerHeight() {
        return this.innerHeight;
    }

    protected double scrollRate() {
        return 9.0;
    }

    public double scrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(double amount) {
        this.scrollAmount = class_3532.method_15350((double)amount, (double)0.0, (double)this.getMaxScrollAmount());
        this.onScroll.accept(this);
    }

    protected void renderBackground(class_332 guiGraphics) {
        if (this.scrollbarVisible()) {
            guiGraphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.method_25364(), 0x75000000);
        }
    }

    private int getContentHeight() {
        return this.getInnerHeight() + 4;
    }

    private int getScrollBarHeight() {
        return class_3532.method_15340((int)((int)((float)(this.field_22759 * this.field_22759) / (float)this.getContentHeight())), (int)16, (int)this.field_22759);
    }

    protected void renderDecorations(class_332 guiGraphics) {
        if (this.scrollbarVisible()) {
            int i = this.getScrollBarHeight();
            int k = Math.max(this.method_46427(), (int)this.scrollAmount() * (this.field_22759 - i) / this.getMaxScrollAmount() + this.method_46427());
            guiGraphics.method_25294(this.method_46426(), k, this.method_46426() + this.method_25368(), k + i, GuiUtils.getSelected().getScrollerColor());
        }
    }

    public void resetWidgets() {
        this.widgets.clear();
        this.setScrollAmount(0.0);
    }

    public void addWidget(class_339 widget) {
        this.widgets.add(widget);
    }

    public void addWidgets(List<class_339> widgets) {
        for (class_339 widget : widgets) {
            this.addWidget(widget);
        }
    }

    protected void method_47399(class_6382 narrationElementOutput) {
        narrationElementOutput.method_37034(class_6381.field_33788, this.method_25369());
    }

    public boolean method_25401(double d, double e, double f, double g) {
        if (!this.field_22764) {
            return false;
        }
        double amount = this.scrollAmount - g * this.scrollRate();
        if (AlinLib.bariumConfig.getBoolean("SCROLLER.SMOOTH", false) && this.scrollbarVisible()) {
            double diff = amount - this.scrollAmount;
            diff = Math.signum(diff) * Math.min(Math.abs(diff), 10.0);
            if (Math.signum(diff *= scrollSpeed) != Math.signum(this.scrollStartVelocity)) {
                diff *= 2.5;
            }
            this.animationTimer *= 0.5;
            this.scrollStartVelocity = ConfigureScrolWidget.scrollbarVelocity(this.animationTimer, this.scrollStartVelocity) + diff;
            this.animationTimer = 0.0;
        } else {
            this.setScrollAmount(amount);
        }
        return true;
    }

    public boolean method_25402(double d, double e, int i) {
        boolean bl2;
        if (!this.field_22764) {
            return false;
        }
        boolean bl = this.withinContentAreaPoint(d, e);
        boolean bl3 = bl2 = this.scrollbarVisible() && d >= (double)this.method_46426() && d <= (double)(this.method_46426() + this.field_22758) && e >= (double)this.method_46427() && e < (double)(this.method_46427() + this.field_22759);
        if (bl2 && i == 0) {
            this.scrolling = true;
            return true;
        }
        return bl || bl2;
    }

    public boolean method_25406(double d, double e, int i) {
        if (i == 0) {
            this.scrolling = false;
        }
        return super.method_25406(d, e, i);
    }

    public boolean method_25403(double d, double e, int i, double f, double g) {
        if (this.field_22764 && this.method_25370() && this.scrolling) {
            if (e < (double)this.method_46427()) {
                this.setScrollAmount(0.0);
            } else if (e > (double)(this.method_46427() + this.field_22759)) {
                this.setScrollAmount(this.getMaxScrollAmount());
            } else {
                int j = this.getScrollBarHeight();
                double h = Math.max(1, this.getMaxScrollAmount() / (this.field_22759 - j));
                this.setScrollAmount(this.scrollAmount + g * h);
            }
            return true;
        }
        return false;
    }

    protected boolean withinContentAreaPoint(double d, double e) {
        return d >= (double)this.method_46426() && d < (double)(this.method_46426() + this.field_22758) && e >= (double)this.method_46427() && e < (double)(this.method_46427() + this.field_22759);
    }

    public boolean method_25404(int i, int j, int k) {
        boolean bl2;
        boolean bl = i == 265;
        boolean bl3 = bl2 = i == 264;
        if (bl || bl2) {
            double d = this.scrollAmount;
            this.setScrollAmount(this.scrollAmount + (double)(bl ? -1 : 1) * this.scrollRate());
            if (d != this.scrollAmount) {
                return true;
            }
        }
        return super.method_25404(i, j, k);
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        if (AlinLib.bariumConfig.getBoolean("SCROLLER.SMOOTH", false)) {
            this.checkOutOfBounds(delta);
            if (Math.abs(ConfigureScrolWidget.scrollbarVelocity(this.animationTimer, this.scrollStartVelocity)) > 1.0) {
                this.applyMotion(delta);
            }
        }
        this.renderBackground(guiGraphics);
        this.renderDecorations(guiGraphics);
    }

    private void applyMotion(float delta) {
        this.scrollAmount += ConfigureScrolWidget.scrollbarVelocity(this.animationTimer, this.scrollStartVelocity) * (double)delta;
        this.animationTimer += (double)(delta * 10.0f) / animationDuration;
        this.onScroll.accept(this);
    }

    private void checkOutOfBounds(float delta) {
        if (this.scrollAmount < 0.0) {
            this.scrollAmount += ConfigureScrolWidget.pushBackStrength(Math.abs(this.scrollAmount), delta);
            if (this.scrollAmount > -0.2) {
                this.scrollAmount = 0.0;
            }
        }
        if (this.scrollAmount > (double)this.getMaxScrollAmount()) {
            this.scrollAmount -= ConfigureScrolWidget.pushBackStrength(this.scrollAmount - (double)this.getMaxScrollAmount(), delta);
            if (this.scrollAmount < (double)this.getMaxScrollAmount() + 0.2) {
                this.scrollAmount = this.getMaxScrollAmount();
            }
        }
    }

    protected boolean scrollbarVisible() {
        return this.getInnerHeight() > this.method_25364();
    }

    protected int getMaxScrollAmount() {
        return Math.max(0, this.getContentHeight() - (this.field_22759 - 4));
    }

    public static double scrollbarVelocity(double timer, double factor) {
        return Math.pow(1.0 - scrollbarDrag, timer) * factor;
    }

    public static double pushBackStrength(double distance, float delta) {
        return (distance + 4.0) * (double)delta / 0.3 / (3.2 / pushBackStrength);
    }
}

