/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.alinlib.gui.components.sliders;

import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_357;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.config.Localization;
import ru.kelcuprum.alinlib.gui.GuiUtils;
import ru.kelcuprum.alinlib.gui.Icons;
import ru.kelcuprum.alinlib.gui.components.Description;
import ru.kelcuprum.alinlib.gui.components.Resetable;
import ru.kelcuprum.alinlib.gui.components.builder.AbstractBuilder;
import ru.kelcuprum.alinlib.gui.components.builder.slider.SliderBuilder;
import ru.kelcuprum.alinlib.gui.components.text.TextBox;
import ru.kelcuprum.alinlib.gui.toast.ToastBuilder;

public class Slider
extends class_357
implements Description,
Resetable {
    public final SliderBuilder builder;
    public Number displayValue = 0;

    public Slider(AbstractBuilder builder) {
        super(builder.getX(), builder.getY(), builder.getWidth(), builder.getHeight(), builder.getTitle(), 0.0);
        this.builder = (SliderBuilder)builder;
        this.field_22763 = builder.getActive();
        this.field_22764 = builder.getVisible();
        if (this.builder.hasConfigurable()) {
            if (this.builder.type == SliderBuilder.NUMBER_TYPE.INTEGER) {
                int selValue = this.builder.config.getNumber(this.builder.configType, this.builder.defaultValue).intValue() - this.builder.min.intValue();
                this.displayValue = this.builder.min.intValue() + selValue;
                this.method_25347((double)selValue / (double)(this.builder.max.intValue() - this.builder.min.intValue()));
            } else if (this.builder.type == SliderBuilder.NUMBER_TYPE.FLOAT) {
                float selValue = this.builder.config.getNumber(this.builder.configType, this.builder.defaultValue).floatValue() - this.builder.min.floatValue();
                this.displayValue = Float.valueOf(this.builder.min.floatValue() + selValue);
                this.method_25347((double)selValue / (double)(this.builder.max.floatValue() - this.builder.min.floatValue()));
            } else if (this.builder.type == SliderBuilder.NUMBER_TYPE.DOUBLE || this.builder.type == SliderBuilder.NUMBER_TYPE.PERCENT) {
                double selValue = this.builder.config.getNumber(this.builder.configType, this.builder.defaultValue).doubleValue() - this.builder.min.doubleValue();
                this.displayValue = this.builder.min.doubleValue() + selValue;
                this.method_25347(selValue / (this.builder.max.doubleValue() - this.builder.min.doubleValue()));
            }
        } else if (this.builder.type == SliderBuilder.NUMBER_TYPE.INTEGER) {
            int selValue = this.builder.defaultValue.intValue() - this.builder.min.intValue();
            this.displayValue = this.builder.min.intValue() + selValue;
            this.method_25347((double)selValue / (double)(this.builder.max.intValue() - this.builder.min.intValue()));
        } else if (this.builder.type == SliderBuilder.NUMBER_TYPE.FLOAT) {
            float selValue = this.builder.defaultValue.floatValue() - this.builder.min.floatValue();
            this.displayValue = Float.valueOf(this.builder.min.floatValue() + selValue);
            this.method_25347(selValue / (this.builder.max.floatValue() - this.builder.min.floatValue()));
        } else if (this.builder.type == SliderBuilder.NUMBER_TYPE.DOUBLE || this.builder.type == SliderBuilder.NUMBER_TYPE.PERCENT) {
            double selValue = this.builder.defaultValue.doubleValue() - this.builder.min.doubleValue();
            this.displayValue = this.builder.min.doubleValue() + selValue;
            this.method_25347(selValue / (this.builder.max.doubleValue() - this.builder.min.doubleValue()));
        }
        this.method_25355((class_2561)class_2561.method_43470((String)this.builder.getTitle().getString()).method_27693(": ").method_10852(this.getComponentValue()));
    }

    public boolean method_37303() {
        return this.builder.getActive();
    }

    public class_2561 getComponentValue() {
        if (this.builder.type == SliderBuilder.NUMBER_TYPE.PERCENT) {
            return class_2561.method_43470((String)(Localization.getRounding(this.displayValue.doubleValue(), true) + "%"));
        }
        if (this.builder.type == SliderBuilder.NUMBER_TYPE.DOUBLE || this.builder.type == SliderBuilder.NUMBER_TYPE.FLOAT) {
            return class_2561.method_43470((String)(Localization.getRounding(this.displayValue.doubleValue()) + this.builder.getValueType()));
        }
        return class_2561.method_43470((String)(this.displayValue.intValue() + this.builder.getValueType()));
    }

    public double getValue() {
        return this.field_22753;
    }

    public Slider setActive(boolean active) {
        this.field_22763 = active;
        return this;
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float tick) {
        if (this.field_22764) {
            this.renderBackground(guiGraphics, mouseX, mouseY, tick);
            this.renderText(guiGraphics, mouseX, mouseY, tick);
        }
    }

    public void renderBackground(class_332 guiGraphics, int mouseX, int mouseY, float tick) {
        if (this.isResetable()) {
            if (this.builder.getStyle() != null) {
                this.builder.getStyle().renderBackground$widget(guiGraphics, this.method_46426(), this.method_46427(), this.method_25364(), this.method_25364(), this.field_22763, this.isHoveredOrFocused(true, mouseX, mouseY));
            }
            guiGraphics.method_25290(class_10799.field_56883, Icons.RESET, this.method_46426() + 2, this.method_46427() + 2, 0.0f, 0.0f, this.method_25364() - 4, this.method_25364() - 4, this.method_25364() - 4, this.method_25364() - 4);
            if (this.builder.getStyle() != null) {
                this.builder.getStyle().renderBackground$slider(guiGraphics, this.getXComponent(), this.method_46427(), this.getWidthComponent(), this.method_25364(), this.field_22763, this.isHoveredOrFocused(false, mouseX, mouseY), this.field_22753);
            }
        } else {
            this.builder.getStyle().renderBackground$slider(guiGraphics, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), this.field_22763, this.method_25367(), this.field_22753);
        }
    }

    public void renderText(class_332 guiGraphics, int mouseX, int mouseY, float tick) {
        if (GuiUtils.isDoesNotFit((class_2561)class_2561.method_43470((String)this.builder.getTitle().getString()).method_27693(": ").method_10852(this.getComponentValue()), this.method_25368(), this.method_25364())) {
            if (this.method_25367()) {
                this.method_25355(this.getComponentValue());
            } else {
                this.method_25355((class_2561)class_2561.method_43470((String)this.builder.getTitle().getString()).method_27693(": ").method_10852(this.getComponentValue()));
            }
            this.renderScrollingString(guiGraphics, AlinLib.MINECRAFT.field_1772, 2, this.builder.getStyle().getTextSliderColor(this.field_22763), this.builder.getStyle().sliderShadow());
        } else if (this.method_49606()) {
            guiGraphics.method_51439(AlinLib.MINECRAFT.field_1772, this.getComponentValue(), this.getXComponent() + this.getWidthComponent() / 2 - AlinLib.MINECRAFT.field_1772.method_1727(this.getComponentValue().getString()) / 2, this.method_46427() + (this.method_25364() - 8) / 2, this.builder.getStyle().getTextSliderColor(this.field_22763), this.builder.getStyle().sliderShadow());
        } else {
            guiGraphics.method_51439(AlinLib.MINECRAFT.field_1772, this.builder.getTitle(), this.getXComponent() + (this.method_25364() - 8) / 2, this.method_46427() + (this.method_25364() - 8) / 2, this.builder.getStyle().getTextSliderColor(this.field_22763), this.builder.getStyle().sliderShadow());
            guiGraphics.method_51439(AlinLib.MINECRAFT.field_1772, this.getComponentValue(), this.method_46426() + this.method_25368() - AlinLib.MINECRAFT.field_1772.method_1727(this.getComponentValue().getString()) - (this.method_25364() - 8) / 2, this.method_46427() + (this.method_25364() - 8) / 2, this.builder.getStyle().getTextSliderColor(this.field_22763), this.builder.getStyle().sliderShadow());
        }
    }

    protected void renderScrollingString(class_332 guiGraphics, class_327 font, int i, int j, boolean shadow) {
        int k = this.method_46426() + i;
        int l = this.method_46426() + this.method_25368() - i;
        TextBox.renderScrollingString(guiGraphics, font, this.method_25369(), k, this.method_46427(), l, this.method_46427() + this.method_25364(), j, shadow);
    }

    protected void method_25346() {
    }

    protected int getWidthComponent() {
        return this.isResetable() ? this.method_25368() - this.method_25364() - 2 : this.method_25368();
    }

    protected int getXComponent() {
        return this.isResetable() ? this.method_46426() + this.method_25364() + 2 : this.method_46426();
    }

    protected boolean isResetable() {
        return this.resettable() && AlinLib.bariumConfig.getBoolean("BUTTON.ENABLE_RESET_BUTTON", true);
    }

    protected void method_49604(class_332 guiGraphics, class_327 font, int i, int j) {
        int k = this.method_46426() + i;
        int l = this.method_46426() + this.method_25368() - i;
        if (this.isResetable()) {
            k += 22;
        }
        Slider.method_52718((class_332)guiGraphics, (class_327)font, (class_2561)this.method_25369(), (int)k, (int)this.method_46427(), (int)l, (int)(this.method_46427() + this.method_25364()), (int)j);
    }

    public void method_25348(double d, double e) {
        if (this.isResetable()) {
            if ((double)this.method_46426() < d && d < (double)(this.method_46426() + this.method_25364())) {
                this.resetValue();
            } else {
                this.setValueFromMouse(d);
            }
        } else {
            super.method_25348(d, e);
        }
    }

    public boolean isHoveredOrFocused(boolean isReset, int mouseX, int mouseY) {
        int x = isReset ? this.method_46426() : this.method_46426() + 22;
        int width = isReset ? 20 : this.method_25368() - 22;
        boolean isHovered = mouseX >= x && mouseY >= this.method_46427() && mouseX < x + width && mouseY < this.method_46427() + this.field_22759;
        return isHovered || !isReset && this.method_25370();
    }

    private void setValueFromMouse(double d) {
        this.method_25347((d - (double)(this.getXComponent() + 4)) / (double)(this.getWidthComponent() - 8));
    }

    protected void method_25349(double d, double e, double f, double g) {
        if (this.isResetable()) {
            if (d > (double)this.getXComponent()) {
                this.setValueFromMouse(d);
            }
        } else {
            super.method_25349(d, e, f, g);
        }
    }

    public boolean method_25404(int i, int j, int k) {
        if (i == 261 && this.resettable()) {
            this.resetValue();
            assert (AlinLib.MINECRAFT != null);
            new ToastBuilder().setTitle(this.builder.getTitle()).setMessage((class_2561)class_2561.method_43471((String)"alinlib.component.value_reset.toast")).setIcon(Icons.RESET).setIsWhiteIcon(true).buildAndShow();
            AlinLib.LOG.log((class_2561)class_2561.method_43471((String)"alinlib.component.reset.toast"));
            return true;
        }
        return super.method_25404(i, j, k);
    }

    protected void method_25344() {
        if (this.builder.type == SliderBuilder.NUMBER_TYPE.INTEGER) {
            int selValue = (int)((double)(this.builder.max.intValue() - this.builder.min.intValue()) * this.field_22753);
            this.displayValue = this.builder.min.intValue() + selValue;
            if (this.builder.hasConfigurable()) {
                this.builder.config.setNumber(this.builder.configType, this.displayValue.intValue());
            }
        } else if (this.builder.type == SliderBuilder.NUMBER_TYPE.DOUBLE) {
            double selValue = (this.builder.max.doubleValue() - this.builder.min.doubleValue()) * this.getValue();
            this.displayValue = this.builder.min.doubleValue() + selValue;
            if (this.builder.hasConfigurable()) {
                this.builder.config.setNumber(this.builder.configType, this.displayValue.doubleValue());
            }
        } else if (this.builder.type == SliderBuilder.NUMBER_TYPE.FLOAT) {
            float selValue = (float)((double)(this.builder.max.floatValue() - this.builder.min.floatValue()) * this.getValue());
            this.displayValue = Float.valueOf(this.builder.min.floatValue() + selValue);
            if (this.builder.hasConfigurable()) {
                this.builder.config.setNumber(this.builder.configType, Float.valueOf(this.displayValue.floatValue()));
            }
        } else if (this.builder.type == SliderBuilder.NUMBER_TYPE.PERCENT) {
            double selValue = (this.builder.max.doubleValue() - this.builder.min.doubleValue()) * this.getValue();
            this.displayValue = (this.builder.min.doubleValue() + selValue) * 100.0;
            if (this.builder.hasConfigurable()) {
                this.builder.config.setNumber(this.builder.configType, this.builder.min.doubleValue() + selValue);
            }
        }
        if (this.builder.getOnPress() != null) {
            this.builder.getOnPress().onPress(this.field_22753);
        }
    }

    @Override
    public void resetValue() {
        if (this.builder.hasConfigurable()) {
            this.builder.config.setNumber(this.builder.configType, this.builder.defaultValue);
            if (this.builder.type == SliderBuilder.NUMBER_TYPE.INTEGER) {
                this.method_25347((double)(this.builder.config.getNumber(this.builder.configType, this.builder.defaultValue).intValue() - this.builder.min.intValue()) / (double)(this.builder.max.intValue() - this.builder.min.intValue()));
            } else if (this.builder.type == SliderBuilder.NUMBER_TYPE.FLOAT) {
                this.method_25347((double)(this.builder.config.getNumber(this.builder.configType, this.builder.defaultValue).floatValue() - this.builder.min.floatValue()) / (double)(this.builder.max.floatValue() - this.builder.min.floatValue()));
            } else if (this.builder.type == SliderBuilder.NUMBER_TYPE.DOUBLE || this.builder.type == SliderBuilder.NUMBER_TYPE.PERCENT) {
                this.method_25347((this.builder.config.getNumber(this.builder.configType, this.builder.defaultValue).doubleValue() - this.builder.min.doubleValue()) / (this.builder.max.doubleValue() - this.builder.min.doubleValue()));
            }
        } else if (this.builder.type == SliderBuilder.NUMBER_TYPE.INTEGER) {
            this.method_25347((double)(this.builder.defaultValue.intValue() - this.builder.min.intValue()) / (double)(this.builder.max.intValue() - this.builder.min.intValue()));
        } else if (this.builder.type == SliderBuilder.NUMBER_TYPE.FLOAT) {
            this.method_25347((double)(this.builder.defaultValue.floatValue() - this.builder.min.floatValue()) / (double)(this.builder.max.floatValue() - this.builder.min.floatValue()));
        } else if (this.builder.type == SliderBuilder.NUMBER_TYPE.DOUBLE || this.builder.type == SliderBuilder.NUMBER_TYPE.PERCENT) {
            this.method_25347((this.builder.defaultValue.doubleValue() - this.builder.min.doubleValue()) / (this.builder.max.doubleValue() - this.builder.min.doubleValue()));
        }
    }

    @Override
    public boolean resettable() {
        return this.builder.hasConfigurable();
    }

    public Slider setDescription(class_2561 description) {
        this.builder.setDescription(description);
        return this;
    }

    @Override
    public class_2561 getDescription() {
        return this.builder.getDescription();
    }

    public static interface OnPress {
        public void onPress(double var1);
    }
}

