/*
 * Decompiled with CFR 0.152.
 */
package ru.kelcuprum.alinlib.gui.screens;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_339;
import net.minecraft.class_437;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.gui.GuiUtils;
import ru.kelcuprum.alinlib.gui.components.Resetable;
import ru.kelcuprum.alinlib.gui.components.builder.AbstractBuilder;
import ru.kelcuprum.alinlib.gui.components.text.CategoryBox;
import ru.kelcuprum.alinlib.gui.screens.AbstractConfigScreen;
import ru.kelcuprum.alinlib.gui.screens.types.ConfigScreen;
import ru.kelcuprum.alinlib.gui.screens.types.ConfigScreen$withoutPanel;
import ru.kelcuprum.alinlib.gui.styles.AbstractStyle;

public class ConfigScreenBuilder {
    public class_2561 title;
    public class_2561 categoryTitle;
    public class_2561 description;
    public class_2960 textureIcon;
    public class_1792 itemIcon;
    public AbstractStyle style;
    public List<class_339> panelWidgets = new ArrayList<class_339>();
    public List<class_339> widgets = new ArrayList<class_339>();
    public OnTick onTick;
    public OnTickScreen onTickScreen;
    public class_437 parent;
    public CustomConfigScreen customConfigScreen;
    public boolean isResetable = false;
    public int panelSize = AlinLib.bariumConfig.getBoolean("CONFIG_SCREEN.SMALL_PANEL_SIZE", false) ? 130 : 190;
    public int yL = AlinLib.bariumConfig.getBoolean("MODERN", true) ? 35 : 40;
    public int yC = 5;
    CategoryBox lastCategory = null;

    public ConfigScreenBuilder(class_437 parent) {
        this(parent, (class_2561)class_2561.method_43470((String)"Change me please"));
    }

    public ConfigScreenBuilder(class_437 parent, class_2561 title) {
        this(parent, title, null);
    }

    public ConfigScreenBuilder(class_437 parent, class_2561 title, AbstractStyle style) {
        this.parent = parent;
        this.title = title;
        this.style = style;
    }

    public ConfigScreenBuilder setTitle(String string) {
        this.setTitle((class_2561)class_2561.method_43470((String)string));
        return this;
    }

    public ConfigScreenBuilder setTitle(class_2561 component) {
        this.title = component;
        return this;
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public ConfigScreenBuilder setDescription(String string) {
        this.setDescription((class_2561)class_2561.method_43470((String)string));
        return this;
    }

    public ConfigScreenBuilder setDescription(class_2561 component) {
        this.description = component;
        return this;
    }

    public class_2561 getDescription() {
        return this.description;
    }

    public AbstractStyle getStyle() {
        return this.style == null ? GuiUtils.getSelected() : this.style;
    }

    public ConfigScreenBuilder setCategoryTitle(String string) {
        this.setCategoryTitle((class_2561)class_2561.method_43470((String)string));
        return this;
    }

    public ConfigScreenBuilder setCategoryTitle(class_2561 component) {
        this.categoryTitle = component;
        return this;
    }

    public class_2561 getCategoryTitle() {
        return this.categoryTitle;
    }

    public ConfigScreenBuilder setIcon(class_1792 item) {
        this.itemIcon = item;
        return this;
    }

    public ConfigScreenBuilder setIcon(class_2960 texture) {
        this.textureIcon = texture;
        return this;
    }

    public class_1792 getItemIcon() {
        return this.itemIcon;
    }

    public class_2960 getTextureIcon() {
        return this.textureIcon;
    }

    public ConfigScreenBuilder setType(AbstractStyle style) {
        this.style = style;
        return this;
    }

    public AbstractStyle getType() {
        return this.style;
    }

    public ConfigScreenBuilder setPanelSize(int panelSize) {
        this.panelSize = panelSize;
        return this;
    }

    public int getPanelSize() {
        return this.panelSize;
    }

    public ConfigScreenBuilder addPanelWidget(AbstractBuilder builder) {
        return this.addPanelWidget(builder.build());
    }

    public ConfigScreenBuilder addPanelWidget(class_339 widget) {
        widget.method_25358(this.panelSize - (AlinLib.bariumConfig.getBoolean("MODERN", true) ? 20 : 10));
        widget.method_46421(AlinLib.bariumConfig.getBoolean("MODERN", true) ? 10 : 5);
        widget.method_46419(this.yL);
        this.yL += widget.method_25364() + 5;
        this.panelWidgets.add(widget);
        return this;
    }

    public ConfigScreenBuilder addPanelWidgets(AbstractBuilder ... widgets) {
        for (AbstractBuilder widget : widgets) {
            this.addPanelWidget(widget);
        }
        return this;
    }

    public ConfigScreenBuilder addPanelWidgets(class_339 ... widgets) {
        for (class_339 widget : widgets) {
            this.addPanelWidget(widget);
        }
        return this;
    }

    public ConfigScreenBuilder addWidget(AbstractBuilder builder) {
        return this.addWidget(builder.build());
    }

    public ConfigScreenBuilder addWidget(class_339 widget) {
        if (widget instanceof CategoryBox) {
            if (this.lastCategory != widget) {
                this.lastCategory = (CategoryBox)widget;
            }
            this.widgets.add(widget);
            widget.method_46421(140);
            widget.method_46419(this.yC);
            this.yC += widget.method_25364() + 5;
            for (class_339 cW : ((CategoryBox)widget).getValues()) {
                this.widgets.add(cW);
                if (!this.isResetable && cW instanceof Resetable) {
                    this.isResetable = true;
                }
                cW.method_46421(140);
                cW.method_46419(this.yC);
                this.yC += cW.method_25364() + 5;
            }
        } else {
            if (this.lastCategory != null && !this.lastCategory.values.contains(widget)) {
                this.yC += 6;
                this.lastCategory.setRenderLine(true);
                this.lastCategory = null;
            }
            this.widgets.add(widget);
            widget.method_46419(this.yC);
            widget.method_46421(140);
            this.yC += widget.method_25364() + 5;
        }
        if (!this.isResetable && widget instanceof Resetable) {
            this.isResetable = true;
        }
        return this;
    }

    public ConfigScreenBuilder addWidgets(AbstractBuilder ... widgets) {
        for (AbstractBuilder widget : widgets) {
            this.addWidget(widget);
        }
        return this;
    }

    public ConfigScreenBuilder addWidgets(class_339 ... widgets) {
        for (class_339 widget : widgets) {
            this.addWidget(widget);
        }
        return this;
    }

    public ConfigScreenBuilder setResetable(boolean isResetable) {
        this.isResetable = isResetable;
        return this;
    }

    public boolean getResetable() {
        return this.isResetable;
    }

    public ConfigScreenBuilder setOnTick(OnTick onTick) {
        this.onTick = onTick;
        return this;
    }

    public ConfigScreenBuilder setOnTickScreen(OnTickScreen onTickScreen) {
        this.onTickScreen = onTickScreen;
        return this;
    }

    public OnTick getOnTick() {
        return this.onTick;
    }

    public ConfigScreenBuilder setParent(class_437 parent) {
        this.parent = parent;
        return this;
    }

    public AbstractConfigScreen build() {
        Objects.requireNonNull(this.title, "title == null");
        if (this.customConfigScreen != null) {
            return this.customConfigScreen.onCreate(this);
        }
        return this.panelWidgets.isEmpty() ? new ConfigScreen$withoutPanel(this) : new ConfigScreen(this);
    }

    public ConfigScreenBuilder setCustomConfigScreen(CustomConfigScreen onCreate) {
        this.customConfigScreen = onCreate;
        return this;
    }

    public static interface OnTick {
        public void onTick(ConfigScreenBuilder var1);
    }

    public static interface OnTickScreen {
        public void onTick(ConfigScreenBuilder var1, AbstractConfigScreen var2);
    }

    public static interface CustomConfigScreen {
        public AbstractConfigScreen onCreate(ConfigScreenBuilder var1);
    }
}

