/*
 * Decompiled with CFR 0.152.
 */
package journeypac.platform;

import java.util.HashSet;
import java.util.Set;
import journeypac.platform.ConfigFacade;
import journeypac.platform.ConfigInfo;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ForgeConfig
implements ConfigFacade {
    public static final ForgeConfig CONFIG;
    public static final ForgeConfigSpec SPEC;
    private final ForgeConfigSpec.BooleanValue showClaims;
    private final ForgeConfigSpec.BooleanValue showForceloads;
    private final ForgeConfigSpec.BooleanValue showClaimant;
    private final ForgeConfigSpec.DoubleValue claimOpacity;
    private final ForgeConfigSpec.DoubleValue forceloadOpacity;
    private final ForgeConfigSpec.DoubleValue forceloadStroke;
    private final ForgeConfigSpec.DoubleValue validAreaOpacity;
    private Set<Runnable> onConfigReload = new HashSet<Runnable>();

    private static ForgeConfigSpec.BooleanValue makeBoolean(ConfigInfo<Boolean> info, ForgeConfigSpec.Builder builder) {
        if (info.getDescription() != null) {
            builder.comment(info.getDescription());
        }
        if (!info.isMutable()) {
            builder.worldRestart();
        }
        return builder.define(info.getName(), info.getInitialValue().booleanValue());
    }

    private static ForgeConfigSpec.DoubleValue makeDouble(ConfigInfo<Double> info, ForgeConfigSpec.Builder builder) {
        if (info.getDescription() != null) {
            builder.comment(info.getDescription());
        }
        if (!info.isMutable()) {
            builder.worldRestart();
        }
        double min = info.getMinimumValue() != null ? info.getMinimumValue() : Double.NEGATIVE_INFINITY;
        double max = info.getMaximumValue() != null ? info.getMaximumValue() : Double.POSITIVE_INFINITY;
        return builder.defineInRange(info.getName(), info.getInitialValue().doubleValue(), min, max);
    }

    private ForgeConfig(ForgeConfigSpec.Builder builder) {
        this.showClaims = ForgeConfig.makeBoolean(ConfigFacade.SHOW_CLAIMS, builder);
        this.showForceloads = ForgeConfig.makeBoolean(ConfigFacade.SHOW_FORCELOADS, builder);
        this.showClaimant = ForgeConfig.makeBoolean(ConfigFacade.SHOW_CLAIMANT, builder);
        this.claimOpacity = ForgeConfig.makeDouble(ConfigFacade.CLAIM_OPACITY, builder);
        this.forceloadOpacity = ForgeConfig.makeDouble(ConfigFacade.FORCELOAD_OPACITY, builder);
        this.forceloadStroke = ForgeConfig.makeDouble(ConfigFacade.FORCELOAD_STROKE, builder);
        this.validAreaOpacity = ForgeConfig.makeDouble(ConfigFacade.VALID_AREA_OPACITY, builder);
    }

    @Override
    public boolean getShowClaims() {
        return (Boolean)this.showClaims.get();
    }

    @Override
    public void setShowClaims(boolean show) {
        this.showClaims.set((Object)show);
        this.showClaims.save();
    }

    @Override
    public boolean getShowForceloads() {
        return (Boolean)this.showForceloads.get();
    }

    @Override
    public boolean getShowClaimant() {
        return (Boolean)this.showClaimant.get();
    }

    @Override
    public double getClaimOpacity() {
        return (Double)this.claimOpacity.get();
    }

    @Override
    public double getForceloadOpacity() {
        return (Double)this.forceloadOpacity.get();
    }

    @Override
    public double getForceloadStroke() {
        return (Double)this.forceloadStroke.get();
    }

    @Override
    public double getValidAreaOpacity() {
        return (Double)this.validAreaOpacity.get();
    }

    public void fireConfigReload() {
        this.onConfigReload.forEach(Runnable::run);
    }

    @Override
    public void onConfigReload(Runnable func) {
        this.onConfigReload.add(func);
    }

    static {
        Pair configPair = new ForgeConfigSpec.Builder().configure(ForgeConfig::new);
        CONFIG = (ForgeConfig)configPair.getLeft();
        SPEC = (ForgeConfigSpec)configPair.getRight();
    }
}

