/*
 * Decompiled with CFR 0.152.
 */
package journeypac.platform;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import journeypac.platform.KeyMapFacade;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public final class ForgeKeyMapFacade
implements KeyMapFacade {
    private final List<KeyMapping> guiMappings = new ArrayList<KeyMapping>();

    public ForgeKeyMapFacade(FMLJavaModLoadingContext context) {
        RegisterKeyMappingsEvent.getBus((BusGroup)context.getModBusGroup()).addListener(this::onRegister);
        ScreenEvent.KeyPressed.Post.BUS.addListener(this::onKeyPressed);
        ScreenEvent.KeyReleased.Post.BUS.addListener(this::onKeyReleased);
        ScreenEvent.MouseButtonPressed.Post.BUS.addListener(this::onMousePressed);
        ScreenEvent.MouseButtonReleased.Post.BUS.addListener(this::onMouseReleased);
    }

    @Override
    public KeyMapping createGui(String category, String description, int keyCode) {
        InputConstants.Key key = InputConstants.Type.KEYSYM.getOrCreate(keyCode);
        KeyMapping mapping = new KeyMapping(description, (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, key, category);
        this.guiMappings.add(mapping);
        return mapping;
    }

    private void onRegister(RegisterKeyMappingsEvent event) {
        this.guiMappings.forEach(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
    }

    private final void onKeyPressed(ScreenEvent.KeyPressed.Post event) {
        this.onInput(InputConstants.Type.KEYSYM.getOrCreate(event.getKeyCode()), true);
    }

    private final void onKeyReleased(ScreenEvent.KeyReleased.Post event) {
        this.onInput(InputConstants.Type.KEYSYM.getOrCreate(event.getKeyCode()), false);
    }

    private final void onMousePressed(ScreenEvent.MouseButtonPressed.Post event) {
        this.onInput(InputConstants.Type.MOUSE.getOrCreate(event.getButton()), true);
    }

    private final void onMouseReleased(ScreenEvent.MouseButtonReleased.Post event) {
        this.onInput(InputConstants.Type.MOUSE.getOrCreate(event.getButton()), false);
    }

    private final void onInput(InputConstants.Key key, boolean pressed) {
        for (KeyMapping curr : this.guiMappings) {
            if (!curr.isActiveAndMatches(key)) continue;
            curr.setDown(pressed);
        }
    }
}

