/*
 * Decompiled with CFR 0.152.
 */
package journeypac.platform;

import java.util.HashSet;
import java.util.Set;
import journeypac.platform.ConfigFacade;
import journeypac.platform.ConfigInfo;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class NeoForgeConfig
implements ConfigFacade {
    public static final NeoForgeConfig CONFIG;
    public static final ModConfigSpec SPEC;
    private final ModConfigSpec.BooleanValue showClaims;
    private final ModConfigSpec.BooleanValue showForceloads;
    private final ModConfigSpec.BooleanValue showClaimant;
    private final ModConfigSpec.DoubleValue claimOpacity;
    private final ModConfigSpec.DoubleValue forceloadOpacity;
    private final ModConfigSpec.DoubleValue forceloadStroke;
    private final ModConfigSpec.DoubleValue validAreaOpacity;
    private Set<Runnable> onConfigReload = new HashSet<Runnable>();

    private static ModConfigSpec.BooleanValue makeBoolean(ConfigInfo<Boolean> info, ModConfigSpec.Builder builder) {
        if (info.getDescription() != null) {
            builder.comment(info.getDescription());
        }
        if (!info.isMutable()) {
            builder.worldRestart();
        }
        return builder.define(info.getName(), info.getInitialValue().booleanValue());
    }

    private static ModConfigSpec.DoubleValue makeDouble(ConfigInfo<Double> info, ModConfigSpec.Builder builder) {
        if (info.getDescription() != null) {
            builder.comment(info.getDescription());
        }
        if (!info.isMutable()) {
            builder.worldRestart();
        }
        double min = info.getMinimumValue() != null ? info.getMinimumValue() : Double.NEGATIVE_INFINITY;
        double max = info.getMaximumValue() != null ? info.getMaximumValue() : Double.POSITIVE_INFINITY;
        return builder.defineInRange(info.getName(), info.getInitialValue().doubleValue(), min, max);
    }

    private NeoForgeConfig(ModConfigSpec.Builder builder) {
        this.showClaims = NeoForgeConfig.makeBoolean(ConfigFacade.SHOW_CLAIMS, builder);
        this.showForceloads = NeoForgeConfig.makeBoolean(ConfigFacade.SHOW_FORCELOADS, builder);
        this.showClaimant = NeoForgeConfig.makeBoolean(ConfigFacade.SHOW_CLAIMANT, builder);
        this.claimOpacity = NeoForgeConfig.makeDouble(ConfigFacade.CLAIM_OPACITY, builder);
        this.forceloadOpacity = NeoForgeConfig.makeDouble(ConfigFacade.FORCELOAD_OPACITY, builder);
        this.forceloadStroke = NeoForgeConfig.makeDouble(ConfigFacade.FORCELOAD_STROKE, builder);
        this.validAreaOpacity = NeoForgeConfig.makeDouble(ConfigFacade.VALID_AREA_OPACITY, builder);
    }

    @Override
    public boolean getShowClaims() {
        return (Boolean)this.showClaims.get();
    }

    @Override
    public void setShowClaims(boolean show) {
        this.showClaims.set((Object)show);
        this.showClaims.save();
    }

    @Override
    public boolean getShowForceloads() {
        return (Boolean)this.showForceloads.get();
    }

    @Override
    public boolean getShowClaimant() {
        return (Boolean)this.showClaimant.get();
    }

    @Override
    public double getClaimOpacity() {
        return (Double)this.claimOpacity.get();
    }

    @Override
    public double getForceloadOpacity() {
        return (Double)this.forceloadOpacity.get();
    }

    @Override
    public double getForceloadStroke() {
        return (Double)this.forceloadStroke.get();
    }

    @Override
    public double getValidAreaOpacity() {
        return (Double)this.validAreaOpacity.get();
    }

    public void fireConfigReload() {
        this.onConfigReload.forEach(Runnable::run);
    }

    @Override
    public void onConfigReload(Runnable func) {
        this.onConfigReload.add(func);
    }

    static {
        Pair configPair = new ModConfigSpec.Builder().configure(NeoForgeConfig::new);
        CONFIG = (NeoForgeConfig)configPair.getLeft();
        SPEC = (ModConfigSpec)configPair.getRight();
    }
}

