/*
 * Decompiled with CFR 0.152.
 */
package journeypac.platform;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import journeypac.platform.KeyMapFacade;
import net.minecraft.client.KeyMapping;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import net.neoforged.neoforge.common.NeoForge;

public final class NeoForgeKeyMapFacade
implements KeyMapFacade {
    private final List<KeyMapping> guiMappings = new ArrayList<KeyMapping>();

    public NeoForgeKeyMapFacade() {
        ModContainer container = ModLoadingContext.get().getActiveContainer();
        container.getEventBus().addListener(this::onRegister);
        NeoForge.EVENT_BUS.addListener(this::onKeyPressed);
        NeoForge.EVENT_BUS.addListener(this::onKeyReleased);
        NeoForge.EVENT_BUS.addListener(this::onMousePressed);
        NeoForge.EVENT_BUS.addListener(this::onMouseReleased);
    }

    @Override
    public KeyMapping createGui(KeyMapping.Category category, String description, int keyCode) {
        InputConstants.Key key = InputConstants.Type.KEYSYM.getOrCreate(keyCode);
        KeyMapping mapping = new KeyMapping(description, (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, key, category);
        this.guiMappings.add(mapping);
        return mapping;
    }

    private void onRegister(RegisterKeyMappingsEvent event) {
        this.guiMappings.forEach(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
    }

    private final void onKeyPressed(ScreenEvent.KeyPressed.Post event) {
        this.onInput(InputConstants.Type.KEYSYM.getOrCreate(event.getKeyCode()), true);
    }

    private final void onKeyReleased(ScreenEvent.KeyReleased.Post event) {
        this.onInput(InputConstants.Type.KEYSYM.getOrCreate(event.getKeyCode()), false);
    }

    private final void onMousePressed(ScreenEvent.MouseButtonPressed.Post event) {
        this.onInput(InputConstants.Type.MOUSE.getOrCreate(event.getButton()), true);
    }

    private final void onMouseReleased(ScreenEvent.MouseButtonReleased.Post event) {
        this.onInput(InputConstants.Type.MOUSE.getOrCreate(event.getButton()), false);
    }

    private final void onInput(InputConstants.Key key, boolean pressed) {
        for (KeyMapping curr : this.guiMappings) {
            if (!curr.isActiveAndMatches(key)) continue;
            curr.setDown(pressed);
        }
    }
}

