/*
 * Decompiled with CFR 0.152.
 */
package journeypac;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.IClientPlugin;
import journeymap.api.v2.client.JourneyMapPlugin;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.display.Displayable;
import journeymap.api.v2.client.display.PolygonOverlay;
import journeymap.api.v2.client.event.DisplayUpdateEvent;
import journeymap.api.v2.client.event.FullscreenMapEvent;
import journeymap.api.v2.client.event.MappingEvent;
import journeymap.api.v2.client.fullscreen.IThemeButton;
import journeymap.api.v2.client.model.MapPolygon;
import journeymap.api.v2.client.model.ShapeProperties;
import journeymap.api.v2.client.model.TextProperties;
import journeymap.api.v2.client.util.UIState;
import journeymap.api.v2.common.event.ClientEventRegistry;
import journeymap.api.v2.common.event.FullscreenEventRegistry;
import journeypac.JourneyPAC;
import journeypac.KeyMappings;
import journeypac.platform.ConfigFacade;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import xaero.pac.client.api.OpenPACClientAPI;
import xaero.pac.client.claims.api.IClientClaimsManagerAPI;
import xaero.pac.client.claims.api.IClientDimensionClaimsManagerAPI;
import xaero.pac.client.claims.api.IClientRegionClaimsAPI;
import xaero.pac.client.claims.player.api.IClientPlayerClaimInfoAPI;
import xaero.pac.common.claims.player.api.IPlayerChunkClaimAPI;
import xaero.pac.common.claims.tracker.api.IClaimsManagerListenerAPI;

@JourneyMapPlugin(apiVersion="2.0.0-SNAPSHOT")
public class MapPlugin
implements IClientPlugin {
    public static final int REGION_BITS = 5;
    public static final int REGION_SIZE = 32;
    public static final int REGION_MASK = 31;
    private IClientAPI jmApi;
    private OpenPACClientAPI opacApi;
    private ConfigFacade config;
    private KeyMappings keyMap;
    private class_5321<class_1937> dimension;
    private boolean showClaims;
    private Map<Long, PolygonOverlay[]> claimMap = new HashMap<Long, PolygonOverlay[]>();
    private KeyMappings.ClaimMode areaMode;
    private boolean areaAdd;
    private int areaStartX;
    private int areaStartZ;
    private PolygonOverlay areaOverlay;
    private int areaEndX;
    private int areaEndZ;
    private PolygonOverlay validOverlay;
    private int validCenterX;
    private int validCenterZ;
    private int validRange;

    public static final long getRegionIndex(int regionX, int regionZ) {
        return (long)regionX & 0xFFFFFFFFL | ((long)regionZ & 0xFFFFFFFFL) << 32;
    }

    public static final int getSubRegionIndex(int chunkX, int chunkZ) {
        return chunkX & 0x1F | (chunkZ & 0x1F) << 5;
    }

    public MapPlugin() {
        JourneyPAC mod = JourneyPAC.getInstance();
        this.config = mod.getConfig();
        this.keyMap = mod.getKeyMappings();
        mod.getEvents().onMousePre(this::onMousePre);
        this.config.onConfigReload(this::onConfigReload);
        this.showClaims = this.config.getShowClaims();
    }

    private void onMousePre(int action, int button) {
        if (action == 0 && this.areaMode != null) {
            IClientClaimsManagerAPI claimsManager = this.opacApi.getClaimsManager();
            if (button == 0 && this.areaAdd) {
                if (this.areaEndX == this.areaStartX && this.areaEndZ == this.areaStartZ) {
                    switch (this.areaMode) {
                        case CLAIM: {
                            claimsManager.requestClaim(this.areaStartX, this.areaStartZ, claimsManager.isServerMode());
                            break;
                        }
                        case FORCELOAD: {
                            claimsManager.requestForceload(this.areaStartX, this.areaStartZ, true, claimsManager.isServerMode());
                            break;
                        }
                        default: {
                            JourneyPAC.LOGGER.warn("Unhandled chunk claim mode " + String.valueOf((Object)this.areaMode));
                            break;
                        }
                    }
                } else {
                    int x0 = Math.min(this.areaStartX, this.areaEndX);
                    int z0 = Math.min(this.areaStartZ, this.areaEndZ);
                    int x1 = Math.max(this.areaStartX, this.areaEndX);
                    int z1 = Math.max(this.areaStartZ, this.areaEndZ);
                    switch (this.areaMode) {
                        case CLAIM: {
                            claimsManager.requestAreaClaim(x0, z0, x1, z1, claimsManager.isServerMode());
                            break;
                        }
                        case FORCELOAD: {
                            claimsManager.requestAreaForceload(x0, z0, x1, z1, true, claimsManager.isServerMode());
                            break;
                        }
                        default: {
                            JourneyPAC.LOGGER.warn("Unhandled area claim mode " + String.valueOf((Object)this.areaMode));
                        }
                    }
                }
                this.areaMode = null;
                if (this.areaOverlay != null) {
                    this.jmApi.remove((Displayable)this.areaOverlay);
                    this.areaOverlay = null;
                }
                if (this.validOverlay != null) {
                    this.jmApi.remove((Displayable)this.validOverlay);
                    this.validOverlay = null;
                }
            } else if (button == 1 && !this.areaAdd) {
                if (this.areaEndX == this.areaStartX && this.areaEndZ == this.areaStartZ) {
                    switch (this.areaMode) {
                        case CLAIM: {
                            claimsManager.requestUnclaim(this.areaStartX, this.areaStartZ, claimsManager.isServerMode());
                            break;
                        }
                        case FORCELOAD: {
                            claimsManager.requestForceload(this.areaStartX, this.areaStartZ, false, claimsManager.isServerMode());
                            break;
                        }
                        default: {
                            JourneyPAC.LOGGER.warn("Unhandled chunk unclaim mode " + String.valueOf((Object)this.areaMode));
                            break;
                        }
                    }
                } else {
                    int x0 = Math.min(this.areaStartX, this.areaEndX);
                    int z0 = Math.min(this.areaStartZ, this.areaEndZ);
                    int x1 = Math.max(this.areaStartX, this.areaEndX);
                    int z1 = Math.max(this.areaStartZ, this.areaEndZ);
                    switch (this.areaMode) {
                        case CLAIM: {
                            claimsManager.requestAreaUnclaim(x0, z0, x1, z1, claimsManager.isServerMode());
                            break;
                        }
                        case FORCELOAD: {
                            claimsManager.requestAreaForceload(x0, z0, x1, z1, false, claimsManager.isServerMode());
                            break;
                        }
                        default: {
                            JourneyPAC.LOGGER.warn("Unhandled area unclaim mode " + String.valueOf((Object)this.areaMode));
                        }
                    }
                }
                this.areaMode = null;
                if (this.areaOverlay != null) {
                    this.jmApi.remove((Displayable)this.areaOverlay);
                    this.areaOverlay = null;
                }
                if (this.validOverlay != null) {
                    this.jmApi.remove((Displayable)this.validOverlay);
                    this.validOverlay = null;
                }
            }
        }
    }

    private void onConfigReload() {
        JourneyPAC.LOGGER.debug("Configs reloaded, rebuilding claim overlay");
        this.showClaims = this.config.getShowClaims();
        try {
            if (this.dimension != null) {
                JourneyPAC.LOGGER.debug("Rebuilding dimension " + String.valueOf(this.dimension.method_29177()));
                this.hideClaims();
                this.claimMap.clear();
                this.buildDimension(this.opacApi.getClaimsManager().getDimension(this.dimension.method_29177()));
                if (this.showClaims) {
                    this.showClaims();
                }
            }
        }
        catch (Exception e) {
            JourneyPAC.LOGGER.error("Error rebuilding claim overlay", (Throwable)e);
        }
    }

    public String getModId() {
        return "journeypac";
    }

    public void initialize(final IClientAPI jmApi) {
        this.jmApi = jmApi;
        ClientEventRegistry.DISPLAY_UPDATE_EVENT.subscribe(this.getModId(), this::onDisplayUpdate);
        ClientEventRegistry.MAPPING_EVENT.subscribe(this.getModId(), this::onMappingStarted);
        FullscreenEventRegistry.FULLSCREEN_MAP_CLICK_EVENT.subscribe(this.getModId(), this::onMapClick);
        FullscreenEventRegistry.FULLSCREEN_MAP_DRAG_EVENT.subscribe(this.getModId(), this::onMapMouseDragged);
        FullscreenEventRegistry.FULLSCREEN_MAP_MOVE_EVENT.subscribe(this.getModId(), this::onMapMouseMove);
        FullscreenEventRegistry.ADDON_BUTTON_DISPLAY_EVENT.subscribe(this.getModId(), event -> event.getThemeButtonDisplay().addThemeToggleButton("button.journeypac.toggle_claims", class_2960.method_60655((String)"journeypac", (String)"textures/gui/opac_btn.png"), this.showClaims, this::onToggleClaims));
        this.opacApi = OpenPACClientAPI.get();
        this.opacApi.getClaimsManager().getTracker().register(new IClaimsManagerListenerAPI(){

            public void onChunkChange(class_2960 dimension, int chunkX, int chunkZ, IPlayerChunkClaimAPI claim) {
                try {
                    class_5321<class_1937> curr = MapPlugin.this.dimension;
                    if (curr != null && curr.method_29177().equals((Object)dimension)) {
                        PolygonOverlay overlay;
                        JourneyPAC.LOGGER.debug("Updating chunk " + chunkX + " " + chunkZ + " in " + String.valueOf(dimension));
                        int regionX = chunkX >> 5;
                        int regionZ = chunkZ >> 5;
                        Long regionPos = MapPlugin.getRegionIndex(regionX, regionZ);
                        int subRegionPos = MapPlugin.getSubRegionIndex(chunkX, chunkZ);
                        PolygonOverlay[] inRegion = MapPlugin.this.claimMap.get(regionPos);
                        PolygonOverlay polygonOverlay = overlay = inRegion != null ? inRegion[subRegionPos] : null;
                        if (overlay != null) {
                            jmApi.remove((Displayable)overlay);
                            inRegion[subRegionPos] = null;
                        }
                        if (claim != null) {
                            if (inRegion == null) {
                                inRegion = new PolygonOverlay[1024];
                                MapPlugin.this.claimMap.put(regionPos, inRegion);
                            }
                            inRegion[subRegionPos] = overlay = MapPlugin.this.makeClaim(chunkX, chunkZ, claim);
                            if (MapPlugin.this.showClaims) {
                                try {
                                    jmApi.show((Displayable)overlay);
                                }
                                catch (Exception e) {
                                    JourneyPAC.LOGGER.error("Error displaying claimed chunks", (Throwable)e);
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    JourneyPAC.LOGGER.error("Error computing chunk changes", (Throwable)e);
                }
            }

            public void onWholeRegionChange(class_2960 dimension, int regionX, int regionZ) {
                try {
                    class_5321<class_1937> curr = MapPlugin.this.dimension;
                    if (curr != null && curr.method_29177().equals((Object)dimension)) {
                        JourneyPAC.LOGGER.debug("Updating region " + regionX + " " + regionZ + " in " + String.valueOf(dimension));
                        IClientDimensionClaimsManagerAPI dimClaims = MapPlugin.this.opacApi.getClaimsManager().getDimension(dimension);
                        if (dimClaims != null) {
                            MapPlugin.this.buildRegion(dimClaims.getRegion(regionX, regionZ));
                        }
                    }
                }
                catch (Exception e) {
                    JourneyPAC.LOGGER.error("Error computing region changes", (Throwable)e);
                }
            }

            public void onDimensionChange(class_2960 dimension) {
                try {
                    class_5321<class_1937> curr = MapPlugin.this.dimension;
                    if (curr != null && curr.method_29177().equals((Object)dimension)) {
                        JourneyPAC.LOGGER.debug("Updating dimension " + String.valueOf(dimension));
                        MapPlugin.this.hideClaims();
                        MapPlugin.this.buildDimension(MapPlugin.this.opacApi.getClaimsManager().getDimension(dimension));
                        MapPlugin.this.showClaims();
                    }
                }
                catch (Exception e) {
                    JourneyPAC.LOGGER.error("Error computing dimension changes", (Throwable)e);
                }
            }
        });
    }

    private void onToggleClaims(IThemeButton btn) {
        try {
            this.showClaims = btn.getToggled() != Boolean.TRUE;
            this.config.setShowClaims(this.showClaims);
            btn.setToggled(Boolean.valueOf(this.showClaims));
            if (!this.claimMap.isEmpty()) {
                if (this.showClaims) {
                    this.showClaims();
                } else {
                    this.hideClaims();
                }
            }
        }
        catch (Exception e) {
            JourneyPAC.LOGGER.error("Error toggling claim display", (Throwable)e);
        }
    }

    private void buildDimension(IClientDimensionClaimsManagerAPI dimClaims) {
        this.claimMap.clear();
        if (dimClaims != null && dimClaims.getCount() > 0) {
            dimClaims.getRegionStream().forEach(this::buildRegion);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void buildRegion(IClientRegionClaimsAPI regionClaims) {
        if (regionClaims != null) {
            void var7_10;
            Long regionPos = (long)regionClaims.getX() & 0xFFFFFFFFL | ((long)regionClaims.getZ() & 0xFFFFFFFFL) << 32;
            Object[] inRegion = this.claimMap.get(regionPos);
            if (inRegion != null) {
                for (PolygonOverlay polygonOverlay : inRegion) {
                    this.jmApi.remove((Displayable)polygonOverlay);
                }
                Arrays.fill(inRegion, null);
            }
            int startX = regionClaims.getX() << 5;
            int startZ = regionClaims.getZ() << 5;
            boolean any = false;
            boolean bl = false;
            while (var7_10 < 32) {
                for (int x = 0; x < 32; ++x) {
                    IPlayerChunkClaimAPI claim = regionClaims.get(x, (int)var7_10);
                    if (claim == null) continue;
                    any = true;
                    PolygonOverlay overlay = this.makeClaim(startX + x, startZ + var7_10, claim);
                    if (inRegion == null) {
                        inRegion = new PolygonOverlay[1024];
                        this.claimMap.put(regionPos, (PolygonOverlay[])inRegion);
                    }
                    inRegion[MapPlugin.getSubRegionIndex((int)x, (int)var7_10)] = overlay;
                }
                ++var7_10;
            }
            if (!any && inRegion != null) {
                this.claimMap.remove(regionPos);
            }
        }
    }

    private PolygonOverlay makeClaim(int chunkX, int chunkZ, IPlayerChunkClaimAPI claim) {
        IClientPlayerClaimInfoAPI playerInfo = this.opacApi.getClaimsManager().getPlayerInfo(claim.getPlayerId());
        Integer subColor = playerInfo.getClaimsColor(claim.getSubConfigIndex());
        int color = subColor != null ? subColor.intValue() : playerInfo.getClaimsColor();
        color &= 0xFFFFFF;
        String trueName = null;
        if (this.config.getShowClaimant()) {
            String playerName = playerInfo.getPlayerUsername();
            String subName = playerInfo.getClaimsName(claim.getSubConfigIndex());
            String name = subName != null ? subName : playerInfo.getClaimsName();
            trueName = name == null || name.isEmpty() ? playerName : playerName + " / " + name;
        }
        ShapeProperties shape = new ShapeProperties().setFillColor(color).setFillOpacity((float)this.config.getClaimOpacity());
        if (this.config.getShowForceloads() && claim.isForceloadable()) {
            shape.setStrokeColor(color).setStrokeOpacity((float)this.config.getForceloadOpacity()).setStrokeWidth((float)this.config.getForceloadStroke());
        } else {
            shape.setStrokeOpacity(0.0f);
        }
        int x0 = chunkX << 4;
        int z0 = chunkZ << 4;
        int x1 = x0 + 16;
        int z1 = z0 + 16;
        MapPolygon area = new MapPolygon(new class_2338[]{new class_2338(x0, 0, z1), new class_2338(x1, 0, z1), new class_2338(x1, 0, z0), new class_2338(x0, 0, z0)});
        PolygonOverlay overlay = new PolygonOverlay(this.getModId(), this.dimension, shape, area);
        if (trueName != null) {
            overlay.setTitle(trueName);
            overlay.setTextProperties(new TextProperties().setColor(color));
        }
        return overlay;
    }

    private void showClaims() {
        if (!this.claimMap.isEmpty()) {
            try {
                for (PolygonOverlay[] inRegion : this.claimMap.values()) {
                    for (PolygonOverlay curr : inRegion) {
                        if (curr == null) continue;
                        this.jmApi.show((Displayable)curr);
                    }
                }
            }
            catch (Exception e) {
                JourneyPAC.LOGGER.error("Error displaying claimed chunks", (Throwable)e);
            }
        }
    }

    private void hideClaims() {
        if (!this.claimMap.isEmpty()) {
            for (PolygonOverlay[] inRegion : this.claimMap.values()) {
                for (PolygonOverlay curr : inRegion) {
                    if (curr == null) continue;
                    this.jmApi.remove((Displayable)curr);
                }
            }
        }
    }

    private void onDisplayUpdate(DisplayUpdateEvent event) {
        try {
            UIState display = event.uiState;
            if (display.ui == Context.UI.Fullscreen && !display.active) {
                this.areaMode = null;
                if (this.areaOverlay != null) {
                    this.jmApi.remove((Displayable)this.areaOverlay);
                    this.areaOverlay = null;
                }
            }
        }
        catch (Exception e) {
            JourneyPAC.LOGGER.error("Error handling event (" + event.getClass().getSimpleName() + ")", (Throwable)e);
        }
    }

    private void onMappingStarted(MappingEvent event) {
        try {
            switch (event.getStage()) {
                case MAPPING_STARTED: {
                    if (this.dimension != null) {
                        JourneyPAC.LOGGER.warn("Started mapping " + String.valueOf(event.dimension.method_29177()) + " but already mapping " + String.valueOf(this.dimension));
                    } else {
                        JourneyPAC.LOGGER.debug("Start mapping " + String.valueOf(event.dimension.method_29177()));
                    }
                    this.dimension = event.dimension;
                    this.buildDimension(this.opacApi.getClaimsManager().getDimension(this.dimension.method_29177()));
                    if (!this.showClaims) break;
                    this.showClaims();
                    break;
                }
                case MAPPING_STOPPED: {
                    if (this.dimension == null) {
                        JourneyPAC.LOGGER.warn("Stopped mapping " + String.valueOf(event.dimension.method_29177()) + " but never started mapping");
                    } else if (!this.dimension.equals((Object)event.dimension)) {
                        JourneyPAC.LOGGER.warn("Stopped mapping " + String.valueOf(event.dimension.method_29177()) + " but currently mapping " + String.valueOf(this.dimension));
                    } else {
                        JourneyPAC.LOGGER.debug("Stop mapping " + String.valueOf(event.dimension.method_29177()));
                    }
                    this.hideClaims();
                    this.claimMap.clear();
                    this.dimension = null;
                }
            }
        }
        catch (Exception e) {
            JourneyPAC.LOGGER.error("Error handling event (" + event.getClass().getSimpleName() + ")", (Throwable)e);
        }
    }

    private void onMapClick(FullscreenMapEvent.ClickEvent event) {
        try {
            KeyMappings.ClaimMode mode;
            if (this.dimension != null && event.dimension == this.dimension && event.getStage() == FullscreenMapEvent.Stage.PRE && this.areaMode == null && (event.getButton() == 0 || event.getButton() == 1) && (mode = this.keyMap.getClaimMode()) != KeyMappings.ClaimMode.NONE) {
                event.cancel();
                this.areaMode = mode;
                this.areaAdd = event.getButton() == 0;
                this.areaStartX = class_4076.method_18675((int)event.getLocation().method_10263());
                this.areaStartZ = class_4076.method_18675((int)event.getLocation().method_10260());
                this.areaEndX = this.areaStartX;
                this.areaEndZ = this.areaStartZ;
            }
        }
        catch (Exception e) {
            JourneyPAC.LOGGER.error("Error handling event (" + event.getClass().getSimpleName() + ")", (Throwable)e);
        }
    }

    private void onMapMouseDragged(FullscreenMapEvent.MouseDraggedEvent event) {
        try {
            if (event.getStage() == FullscreenMapEvent.Stage.PRE && this.areaMode != null && (event.getButton() == 0 && this.areaAdd || event.getButton() == 1 && !this.areaAdd)) {
                event.cancel();
            }
        }
        catch (Exception e) {
            JourneyPAC.LOGGER.error("Error handling event (" + event.getClass().getSimpleName() + ")", (Throwable)e);
        }
    }

    private void onMapMouseMove(FullscreenMapEvent.MouseMoveEvent event) {
        try {
            if (this.areaMode != null) {
                float validOpacity;
                int currX = class_4076.method_18675((int)event.getLocation().method_10263());
                int currZ = class_4076.method_18675((int)event.getLocation().method_10260());
                if (this.areaOverlay == null || currX != this.areaEndX || currZ != this.areaEndZ) {
                    this.areaEndX = currX;
                    this.areaEndZ = currZ;
                    int x0 = class_4076.method_18688((int)Math.min(currX, this.areaStartX));
                    int z0 = class_4076.method_18688((int)Math.min(currZ, this.areaStartZ));
                    int x1 = class_4076.method_18688((int)(Math.max(currX, this.areaStartX) + 1));
                    int z1 = class_4076.method_18688((int)(Math.max(currZ, this.areaStartZ) + 1));
                    MapPolygon area = new MapPolygon(new class_2338[]{new class_2338(x0, 0, z1), new class_2338(x1, 0, z1), new class_2338(x1, 0, z0), new class_2338(x0, 0, z0)});
                    if (this.areaOverlay == null) {
                        ShapeProperties shape = new ShapeProperties().setStrokeColor(0xFFFFFF).setFillColor(0xFFFFFF).setFillOpacity((float)this.config.getClaimOpacity());
                        this.areaOverlay = new PolygonOverlay(this.getModId(), this.dimension, shape, area);
                    } else {
                        this.areaOverlay.setOuterArea(area);
                        this.areaOverlay.flagForRerender();
                    }
                    this.jmApi.show((Displayable)this.areaOverlay);
                }
                if ((validOpacity = (float)this.config.getValidAreaOpacity()) > 0.0f) {
                    class_310 mc = class_310.method_1551();
                    if (mc.field_1724 != null) {
                        class_1923 chunk = mc.field_1724.method_31476();
                        int chunkX = chunk.field_9181;
                        int chunkZ = chunk.field_9180;
                        int range = this.opacApi.getClaimsManager().getMaxClaimDistance();
                        if (this.validOverlay == null || chunkX != this.validCenterX || chunkZ != this.validCenterZ || range != this.validRange) {
                            int x0 = class_4076.method_18688((int)(chunkX - range)) - 1;
                            int z0 = class_4076.method_18688((int)(chunkZ - range)) - 1;
                            int x1 = class_4076.method_18688((int)(chunkX + range + 1)) + 1;
                            int z1 = class_4076.method_18688((int)(chunkZ + range + 1)) + 1;
                            MapPolygon area = new MapPolygon(new class_2338[]{new class_2338(x0, 0, z1), new class_2338(x1, 0, z1), new class_2338(x1, 0, z0), new class_2338(x0, 0, z0)});
                            if (this.validOverlay == null) {
                                ShapeProperties shape = new ShapeProperties().setStrokeColor(0xBFBFBF).setStrokeOpacity(validOpacity).setFillOpacity(0.0f).setStrokeWidth(2.0f);
                                this.validOverlay = new PolygonOverlay(this.getModId(), this.dimension, shape, area);
                            } else {
                                this.validOverlay.setOuterArea(area);
                                this.validOverlay.flagForRerender();
                            }
                            this.jmApi.show((Displayable)this.validOverlay);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            JourneyPAC.LOGGER.error("Error handling event (" + event.getClass().getSimpleName() + ")", (Throwable)e);
        }
    }
}

