/*
 * Decompiled with CFR 0.152.
 */
package journeypac.platform;

import java.util.function.BiConsumer;
import java.util.function.ObjDoubleConsumer;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import journeypac.platform.ConfigInfo;
import journeypac.platform.FabricConfig;

public abstract class ConfigEntry<T> {
    private int index;
    protected final ConfigInfo<T> info;

    protected ConfigEntry(ConfigInfo<T> info) {
        this.info = info;
    }

    public int getIndex() {
        return this.index;
    }

    void setIndex(int index) {
        this.index = index;
    }

    public ConfigInfo<T> getInfo() {
        return this.info;
    }

    public abstract void reset(FabricConfig var1);

    public abstract boolean load(FabricConfig var1, String var2);

    public abstract String save(FabricConfig var1);

    public static final class DoubleConfig
    extends ConfigEntry<Double> {
        private ToDoubleFunction<FabricConfig> getter;
        private ObjDoubleConsumer<FabricConfig> setter;

        public DoubleConfig(ConfigInfo<Double> info, ToDoubleFunction<FabricConfig> getter, ObjDoubleConsumer<FabricConfig> setter) {
            super(info);
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public void reset(FabricConfig config) {
            this.setter.accept(config, (Double)this.info.getInitialValue());
        }

        @Override
        public boolean load(FabricConfig config, String val) {
            double dbl = Double.parseDouble(val);
            if (this.info.getMinimumValue() != null && dbl < (Double)this.info.getMinimumValue()) {
                this.setter.accept(config, (Double)this.info.getMinimumValue());
                return false;
            }
            if (this.info.getMaximumValue() != null && dbl > (Double)this.info.getMaximumValue()) {
                this.setter.accept(config, (Double)this.info.getMaximumValue());
                return false;
            }
            this.setter.accept(config, dbl);
            return true;
        }

        @Override
        public String save(FabricConfig config) {
            return Double.toString(this.getter.applyAsDouble(config));
        }
    }

    public static final class BooleanConfig
    extends ConfigEntry<Boolean> {
        private Predicate<FabricConfig> getter;
        private BiConsumer<FabricConfig, Boolean> setter;

        public BooleanConfig(ConfigInfo<Boolean> info, Predicate<FabricConfig> getter, BiConsumer<FabricConfig, Boolean> setter) {
            super(info);
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public void reset(FabricConfig config) {
            this.setter.accept(config, (Boolean)this.info.getInitialValue());
        }

        @Override
        public boolean load(FabricConfig config, String val) {
            this.setter.accept(config, Boolean.parseBoolean(val));
            return true;
        }

        @Override
        public String save(FabricConfig config) {
            return Boolean.toString(this.getter.test(config));
        }
    }
}

