/*
 * Decompiled with CFR 0.152.
 */
package journeypac.platform;

import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Stream;
import journeypac.JourneyPAC;
import journeypac.platform.ConfigEntry;
import journeypac.platform.ConfigFacade;
import net.minecraft.class_310;

public class FabricConfig
implements ConfigFacade {
    private static final ConfigEntry[] CONFIGS = new ConfigEntry[]{new ConfigEntry.BooleanConfig(ConfigFacade.SHOW_CLAIMS, c -> c.showClaims, (c, v) -> {
        c.showClaims = v;
    }), new ConfigEntry.BooleanConfig(ConfigFacade.SHOW_FORCELOADS, c -> c.showForceloads, (c, v) -> {
        c.showForceloads = v;
    }), new ConfigEntry.BooleanConfig(ConfigFacade.SHOW_CLAIMANT, c -> c.showClaimant, (c, v) -> {
        c.showClaimant = v;
    }), new ConfigEntry.DoubleConfig(ConfigFacade.CLAIM_OPACITY, c -> c.claimOpacity, (c, v) -> {
        c.claimOpacity = v;
    }), new ConfigEntry.DoubleConfig(ConfigFacade.FORCELOAD_OPACITY, c -> c.forceloadOpacity, (c, v) -> {
        c.forceloadOpacity = v;
    }), new ConfigEntry.DoubleConfig(ConfigFacade.FORCELOAD_STROKE, c -> c.forceloadStroke, (c, v) -> {
        c.forceloadStroke = v;
    }), new ConfigEntry.DoubleConfig(ConfigFacade.VALID_AREA_OPACITY, c -> c.validAreaOpacity, (c, v) -> {
        c.validAreaOpacity = v;
    })};
    private static final HashMap<String, ConfigEntry> CONFIG_MAP = new HashMap();
    private final Path path;
    private boolean showClaims;
    private boolean showForceloads;
    private boolean showClaimant;
    private double claimOpacity;
    private double forceloadOpacity;
    private double forceloadStroke;
    private double validAreaOpacity;

    public FabricConfig(Path folder) {
        this.path = folder.resolve("journeypac-client.toml");
        for (ConfigEntry cfg : CONFIGS) {
            cfg.reset(this);
        }
    }

    public void load(boolean initial) {
        boolean[] sync = new boolean[1 + CONFIGS.length];
        sync[0] = true;
        try (Stream<String> lines = Files.lines(this.path);){
            lines.map(String::trim).filter(l -> !l.isEmpty() && l.charAt(0) != '#').forEach(line -> {
                int idx = line.indexOf(61);
                if (idx < 0) {
                    sync[0] = false;
                    JourneyPAC.LOGGER.warn("Malformed configuration file");
                    return;
                }
                String key = line.substring(0, idx).trim();
                ConfigEntry cfg = CONFIG_MAP.get(key);
                if (cfg == null) {
                    sync[0] = false;
                    JourneyPAC.LOGGER.warn("No such config element: " + key);
                    return;
                }
                if (initial || cfg.getInfo().isMutable()) {
                    try {
                        sync[0] = sync[0] & !sync[1 + cfg.getIndex()];
                        sync[1 + cfg.getIndex()] = true;
                        sync[0] = sync[0] & cfg.load(this, line.substring(idx + 1).trim());
                    }
                    catch (Exception e) {
                        JourneyPAC.LOGGER.warn("Could not load config " + cfg.getInfo().getName() + System.lineSeparator() + e.toString());
                        cfg.reset(this);
                        sync[0] = false;
                    }
                }
            });
            for (int i = 1; i <= CONFIGS.length; ++i) {
                sync[0] = sync[0] & sync[i];
            }
        }
        catch (NoSuchFileException e) {
            sync[0] = false;
        }
        catch (Exception e) {
            JourneyPAC.LOGGER.error("Error loading configs", (Throwable)e);
            sync[0] = false;
        }
        if (!sync[0]) {
            JourneyPAC.LOGGER.info("Saving desynced configs");
            this.save();
        }
    }

    public void save() {
        try {
            ArrayList<Object> lines = new ArrayList<Object>();
            for (ConfigEntry cfg : CONFIGS) {
                if (cfg.getInfo().getDescription() != null) {
                    cfg.getInfo().getDescription().lines().map(s -> "#" + s).forEach(lines::add);
                }
                if (cfg.getInfo().getMinimumValue() != null || cfg.getInfo().getMaximumValue() != null) {
                    lines.add("#Range: " + String.valueOf(cfg.getInfo().getMinimumValue()) + " ~ " + String.valueOf(cfg.getInfo().getMaximumValue()));
                }
                lines.add(cfg.getInfo().getName() + " = " + cfg.save(this));
            }
            lines.add("");
            Files.write(this.path, lines, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Exception e) {
            JourneyPAC.LOGGER.error("Error saving configs", (Throwable)e);
        }
    }

    @Override
    public boolean getShowClaims() {
        return this.showClaims;
    }

    @Override
    public void setShowClaims(boolean show) {
        if (this.showClaims != show) {
            this.showClaims = show;
            class_310.method_1551().execute(this::save);
        }
    }

    @Override
    public boolean getShowForceloads() {
        return this.showForceloads;
    }

    @Override
    public boolean getShowClaimant() {
        return this.showClaimant;
    }

    @Override
    public double getClaimOpacity() {
        return this.claimOpacity;
    }

    @Override
    public double getForceloadOpacity() {
        return this.forceloadOpacity;
    }

    @Override
    public double getForceloadStroke() {
        return this.forceloadStroke;
    }

    @Override
    public double getValidAreaOpacity() {
        return this.validAreaOpacity;
    }

    @Override
    public void onConfigReload(Runnable func) {
    }

    static {
        for (int i = 0; i < CONFIGS.length; ++i) {
            CONFIGS[i].setIndex(i);
            CONFIG_MAP.put(CONFIGS[i].getInfo().getName(), CONFIGS[i]);
        }
    }
}

