/*
 * Decompiled with CFR 0.152.
 */
package to.lodestone.bookshelfapi.api;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.JSONArray;
import org.json.JSONObject;

public class VersionUpdater
implements Listener {
    private final JavaPlugin plugin;
    private final String name;
    private final String latestVersion;
    private final String currentVersion;
    private final String baseUrl;

    public VersionUpdater(JavaPlugin plugin, String name, String baseUrl, String updateUrl, String currentVersion) {
        this.plugin = plugin;
        this.baseUrl = baseUrl;
        this.currentVersion = currentVersion;
        this.name = name;
        this.latestVersion = this.getLatestVersion(updateUrl);
        if (this.latestVersion != null && this.isNewerVersion(this.latestVersion, currentVersion)) {
            plugin.getLogger().severe("=================================");
            plugin.getLogger().severe(String.format("A newer version of %s is available for download in Modrinth!", name));
            plugin.getLogger().severe(String.format("Newest Version: %s | Current Version: %s", this.latestVersion, currentVersion));
            plugin.getLogger().severe(String.format("%s/version/%s", this.baseUrl, this.latestVersion));
            plugin.getLogger().severe("=================================");
        }
    }

    @EventHandler
    public void on(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (player.isOp() && this.latestVersion != null && this.isNewerVersion(this.latestVersion, this.currentVersion)) {
                player.sendMessage((Component)Component.empty());
                player.sendMessage(MiniMessage.miniMessage().deserialize((Object)String.format("  A newer version of <yellow>%s <reset>is available for download.", this.name)));
                player.sendMessage(MiniMessage.miniMessage().deserialize((Object)String.format("  Newest Version: <green>%s <reset>| <reset>Current Version: <yellow>%s", this.latestVersion, this.currentVersion)));
                player.sendMessage(MiniMessage.miniMessage().deserialize((Object)String.format("  <white>Update %s at <hover:show_text:'<green>Update %s at Modrinth!'><click:open_url:%s/version/%s><underlined><green>Modrinth!", this.name, this.name, this.baseUrl, this.latestVersion)));
                player.sendMessage((Component)Component.empty());
            }
        }, 30L);
    }

    private String getLatestVersion(String urlString) {
        try {
            URL url = new URL(urlString);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            int responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                JSONArray jsonArray = new JSONArray(response.toString());
                return ((JSONObject)jsonArray.get(0)).getString("version_number");
            }
            this.plugin.getLogger().severe("=================================");
            this.plugin.getLogger().severe(String.format("Failed to retrieve latest version of %s from Modrinth!", this.name));
            this.plugin.getLogger().severe("\"version_number\" is missing or status didn't return OK");
            this.plugin.getLogger().severe("=================================");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("=================================");
            this.plugin.getLogger().severe(String.format("Failed to retrieve latest version of %s from Modrinth!", this.name));
            e.printStackTrace();
            this.plugin.getLogger().severe("=================================");
        }
        return null;
    }

    private boolean isNewerVersion(String latestVersion, String currentVersion) {
        latestVersion = latestVersion.replaceAll("beta", "").replaceAll("alpha", "").replaceAll("private", "").replaceAll("-", "").replaceAll("v", "");
        currentVersion = currentVersion.replaceAll("beta", "").replaceAll("alpha", "").replaceAll("private", "").replaceAll("-", "").replaceAll("v", "");
        String[] latestParts = latestVersion.split("\\+")[0].split("-");
        String[] currentParts = currentVersion.split("\\+")[0].split("-");
        String[] latestVersionParts = latestParts[0].split("\\.");
        String[] currentVersionParts = currentParts[0].split("\\.");
        int maxLength = Math.max(latestVersionParts.length, currentVersionParts.length);
        for (int i = 0; i < maxLength; ++i) {
            int currentPart;
            int latestPart = i < latestVersionParts.length ? Integer.parseInt(latestVersionParts[i]) : 0;
            int n = currentPart = i < currentVersionParts.length ? Integer.parseInt(currentVersionParts[i]) : 0;
            if (latestPart > currentPart) {
                return true;
            }
            if (latestPart >= currentPart) continue;
            return false;
        }
        if (latestParts.length > 1 && currentParts.length == 1) {
            return false;
        }
        if (currentParts.length > 1 && latestParts.length == 1) {
            return true;
        }
        if (latestParts.length > 1 && currentParts.length > 1) {
            return latestParts[1].compareTo(currentParts[1]) > 0;
        }
        return false;
    }
}

