/*
 * Decompiled with CFR 0.152.
 */
package to.lodestone.bookshelfapi.api.menu;

import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import to.lodestone.bookshelfapi.BookshelfAPI;
import to.lodestone.bookshelfapi.api.menu.build.MenuBuilder;
import to.lodestone.bookshelfapi.api.menu.build.RowBuilder;
import to.lodestone.bookshelfapi.api.menu.build.TopMenuBuilder;

public abstract class Menu
implements InventoryHolder {
    protected Inventory inventory;
    private TopMenuBuilder topMenuBuilder;
    private MenuBuilder bottomMenuBuilder;
    protected final Player player;

    public Menu(Player player) {
        this.player = player;
    }

    protected void init() {
        this.topMenuBuilder = this.getTopMenuBuilder(new TopMenuBuilder());
        int rows = this.topMenuBuilder.getRows();
        if (this.inventory == null) {
            this.inventory = Bukkit.createInventory(null, (int)(rows * 9), (Component)this.topMenuBuilder.getTitle());
        }
        if (this.topMenuBuilder.getRowBuilders().length > 6) {
            throw new IllegalArgumentException("Invalid top rows created! Size must be from 1-6");
        }
        RowBuilder @NotNull [] rowBuilders = this.topMenuBuilder.getRowBuilders();
        for (int y = 0; y < rowBuilders.length; ++y) {
            RowBuilder rowBuilder = rowBuilders[y];
            if (rowBuilder == null) continue;
            @NotNull RowBuilder.Slot[] slots = rowBuilder.getSlots();
            for (int x = 0; x < slots.length; ++x) {
                RowBuilder.Slot slot = slots[x];
                if (slot.itemStack() == null) continue;
                this.inventory.setItem(y * 9 + x, slot.itemStack());
            }
        }
        this.bottomMenuBuilder = this.getBottomMenuBuilder(new MenuBuilder());
        if (this.bottomMenuBuilder != null) {
            RowBuilder @NotNull [] bottomRowBuilders = this.bottomMenuBuilder.getRowBuilders();
            if (bottomRowBuilders.length > 4) {
                throw new IllegalArgumentException("Invalid bottom rows created! Size must be 1-4");
            }
            for (int y = 0; y < bottomRowBuilders.length; ++y) {
                RowBuilder rowBuilder = bottomRowBuilders[y];
                if (rowBuilder == null) continue;
                RowBuilder.Slot @NotNull [] slots = rowBuilder.getSlots();
                for (int x = 0; x < slots.length; ++x) {
                    RowBuilder.Slot slot = slots[x];
                    if (slot.itemStack() == null) continue;
                    this.player.getInventory().setItem(y * 9 + x, slot.itemStack());
                }
            }
        }
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public void update() {
        this.init();
    }

    public void open() {
        this.init();
        this.topMenuBuilder.getOpenActions().forEach(event -> event.accept(null));
        BookshelfAPI.getApi().getMenuManager().register(this.player.getUniqueId(), this);
        if (this.player.getOpenInventory().getTopInventory().equals((Object)this.inventory)) {
            return;
        }
        this.player.openInventory(this.inventory);
    }

    public void close() {
        this.player.closeInventory(InventoryCloseEvent.Reason.PLUGIN);
    }

    public TopMenuBuilder getTopMenuBuilder() {
        return this.topMenuBuilder;
    }

    public MenuBuilder getBottomMenuBuilder() {
        return this.bottomMenuBuilder;
    }

    @NotNull
    protected abstract TopMenuBuilder getTopMenuBuilder(TopMenuBuilder var1);

    @Nullable
    protected abstract MenuBuilder getBottomMenuBuilder(MenuBuilder var1);
}

