/*
 * Decompiled with CFR 0.152.
 */
package to.lodestone.bookshelfapi.api.menu.build;

import java.util.Arrays;
import java.util.function.Consumer;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import to.lodestone.bookshelfapi.api.menu.build.RowBuilder;

public class MenuBuilder {
    protected RowBuilder @NotNull [] rowBuilders = new RowBuilder[4];

    public MenuBuilder() {
        Arrays.fill(this.rowBuilders, new RowBuilder());
    }

    public MenuBuilder buildRow(int index, Consumer<RowBuilder> consumer) {
        RowBuilder builder = new RowBuilder();
        consumer.accept(builder);
        this.rowBuilders[index] = builder;
        return this;
    }

    public void setItem(int slot, ItemStack itemStack, @Nullable Consumer<InventoryClickEvent> consumer) {
        int row = slot / 9;
        int column = slot % 9;
        this.rowBuilders[row].setSlot(column, itemStack, consumer);
    }

    public void setItem(int slot, ItemStack itemStack) {
        int row = slot / 9;
        int column = slot % 9;
        this.rowBuilders[row].setSlot(column, itemStack, null);
    }

    public void set(int row, int column, ItemStack itemStack, @Nullable Consumer<InventoryClickEvent> consumer) {
        this.rowBuilders[row].setSlot(column, itemStack, consumer);
    }

    public void set(int row, int column, ItemStack itemStack) {
        this.rowBuilders[row].setSlot(column, itemStack, null);
    }

    public RowBuilder[] getRowBuilders() {
        return this.rowBuilders;
    }

    public void process(int slot, InventoryClickEvent event) {
        for (int y = 0; y < this.rowBuilders.length; ++y) {
            RowBuilder rowBuilder = this.rowBuilders[y];
            RowBuilder.Slot[] slots = rowBuilder.getSlots();
            for (int x = 0; x < slots.length; ++x) {
                RowBuilder.Slot builderSlot = slots[x];
                if (builderSlot.event() == null || slot != y * 9 + x) continue;
                builderSlot.event().accept(event);
                return;
            }
        }
    }
}

