/*
 * Decompiled with CFR 0.152.
 */
package to.lodestone.bookshelfapi.api.menu.build;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;
import to.lodestone.bookshelfapi.api.menu.build.MenuBuilder;
import to.lodestone.bookshelfapi.api.menu.build.RowBuilder;
import to.lodestone.bookshelfapi.api.util.MiniMessageUtil;

public class TopMenuBuilder
extends MenuBuilder {
    private Component title = Component.empty();
    private int rows;
    protected List<Consumer<InventoryCloseEvent>> closeActions = new ArrayList<Consumer<InventoryCloseEvent>>();
    protected List<Consumer<Void>> openActions = new ArrayList<Consumer<Void>>();
    protected List<Consumer<InventoryClickEvent>> clickActions = new ArrayList<Consumer<InventoryClickEvent>>();

    public TopMenuBuilder setTitle(Component title) {
        this.title = title;
        return this;
    }

    public TopMenuBuilder addCloseAction(Consumer<InventoryCloseEvent> consumer) {
        this.closeActions.add(consumer);
        return this;
    }

    public TopMenuBuilder addOpenAction(Consumer<Void> consumer) {
        this.openActions.add(consumer);
        return this;
    }

    public TopMenuBuilder addClickAction(Consumer<InventoryClickEvent> consumer) {
        this.clickActions.add(consumer);
        return this;
    }

    public TopMenuBuilder setRows(int rows) {
        if (rows > 6 || rows <= 0) {
            throw new IllegalArgumentException("Invalid row size! Must be from 1-6");
        }
        this.rows = rows;
        this.rowBuilders = new RowBuilder[rows];
        for (int i = 0; i < rows; ++i) {
            this.rowBuilders[i] = new RowBuilder();
        }
        return this;
    }

    public TopMenuBuilder outline(ItemStack outlineItem) {
        for (int y = 0; y < this.rows; ++y) {
            int finalY = y;
            this.buildRow(y, rowBuilder -> {
                for (int x = 0; x < 9; ++x) {
                    if (finalY != 0 && finalY != this.rows - 1 && x != 0 && x != 8) continue;
                    rowBuilder.setSlot(x, outlineItem, event -> event.setCancelled(true));
                }
            });
        }
        return this;
    }

    public TopMenuBuilder fill(ItemStack fillContent) {
        for (int y = 0; y < this.rows; ++y) {
            this.buildRow(y, rowBuilder -> {
                for (int x = 0; x < 9; ++x) {
                    rowBuilder.setSlot(x, fillContent);
                }
            });
        }
        return this;
    }

    public TopMenuBuilder setTitle(String title, Object ... args) {
        this.title = MiniMessageUtil.deserialize(title, args);
        return this;
    }

    @Override
    public TopMenuBuilder buildRow(int index, Consumer<RowBuilder> consumer) {
        if (this.rows > 6 || this.rows <= 0 || index > this.rows) {
            throw new IllegalArgumentException(String.format("Invalid row size! Must be inserting from 1-%s", this.rows));
        }
        return (TopMenuBuilder)super.buildRow(index, consumer);
    }

    public TopMenuBuilder editRow(int rowIndex, Consumer<RowBuilder> consumer) {
        if (this.rowBuilders.length < rowIndex) {
            throw new IllegalArgumentException("Invalid row index! Must be from 0-" + (this.rowBuilders.length - 1));
        }
        consumer.accept(this.rowBuilders[rowIndex]);
        return this;
    }

    public TopMenuBuilder insertInRow(int rowIndex, int slot, ItemStack itemStack) {
        if (this.rows > 6 || this.rows <= 0 || rowIndex > this.rows - 1) {
            throw new IllegalArgumentException(String.format("Invalid row size! Must be inserting from 1-%s", this.rows));
        }
        return this.insertInRow(rowIndex, slot, itemStack, null);
    }

    public TopMenuBuilder insertInRow(int rowIndex, int slot, ItemStack itemStack, Consumer<InventoryClickEvent> consumer) {
        if (this.rows > 6 || this.rows <= 0 || rowIndex > this.rows - 1) {
            throw new IllegalArgumentException(String.format("Invalid row size! Must be inserting from 1-%s", this.rows));
        }
        this.rowBuilders[rowIndex].setSlot(slot, itemStack, consumer);
        return this;
    }

    public Component getTitle() {
        return this.title;
    }

    public List<Consumer<Void>> getOpenActions() {
        return this.openActions;
    }

    public List<Consumer<InventoryCloseEvent>> getCloseActions() {
        return this.closeActions;
    }

    public List<Consumer<InventoryClickEvent>> getClickActions() {
        return this.clickActions;
    }

    public int getRows() {
        if (this.rows > 6 || this.rows <= 0) {
            throw new IllegalArgumentException("Invalid row size! Must be from 1-6");
        }
        return this.rows;
    }
}

