/*
 * Decompiled with CFR 0.152.
 */
package to.lodestone.bookshelfapi.api.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ArgumentParserUtil {
    public static ParsedArguments parseArguments(String input) {
        return ArgumentParserUtil.parseArguments(input, Collections.emptySet());
    }

    public static ParsedArguments parseArguments(String input, Set<String> validFlags) {
        ArrayList<String> cleanedArgs = new ArrayList<String>();
        HashMap<String, String> flagMap = new HashMap<String, String>();
        String[] args = input.split(" ");
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (validFlags.contains(arg)) {
                if (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                    flagMap.put(arg, args[i + 1]);
                    ++i;
                    continue;
                }
                flagMap.put(arg, "");
                continue;
            }
            cleanedArgs.add(arg);
        }
        return new ParsedArguments(String.join((CharSequence)" ", cleanedArgs), flagMap);
    }

    public record ParsedArguments(String cleanedArgs, Map<String, String> flags) {
        public boolean hasFlag(String flag) {
            return this.flags.containsKey(flag);
        }

        public boolean hasFlag(String ... flags) {
            for (String flag : flags) {
                if (!this.hasFlag(flag)) continue;
                return true;
            }
            return false;
        }

        public String getFlag(String flag) {
            return this.flags.get(flag);
        }
    }
}

