/*
 * Decompiled with CFR 0.152.
 */
package to.lodestone.bookshelfapi.api.util;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import to.lodestone.bookshelfapi.api.util.MiniMessageUtil;

public class ChatHeadUtil {
    private static final HashMap<UUID, String> cachedSkinUrls = new HashMap();

    public static String saturateColor(String primaryHex, String saturaterHex, double saturationFactor) {
        Color primaryColor = Color.decode(primaryHex);
        Color saturaterColor = Color.decode(saturaterHex);
        int red = (int)((double)primaryColor.getRed() * (1.0 - saturationFactor) + (double)saturaterColor.getRed() * saturationFactor);
        int green = (int)((double)primaryColor.getGreen() * (1.0 - saturationFactor) + (double)saturaterColor.getGreen() * saturationFactor);
        int blue = (int)((double)primaryColor.getBlue() * (1.0 - saturationFactor) + (double)saturaterColor.getBlue() * saturationFactor);
        Color saturatedColor = new Color(red, green, blue);
        return String.format("#%02x%02x%02x", saturatedColor.getRed(), saturatedColor.getGreen(), saturatedColor.getBlue());
    }

    public static String _getHead(Player player) {
        return ChatHeadUtil._getHead(player.getUniqueId(), null);
    }

    public static Component getHead(Player player) {
        return ChatHeadUtil.getHead(player.getUniqueId(), null);
    }

    public static Component getHead(Player player, String saturateWith) {
        return ChatHeadUtil.getHead(player.getUniqueId(), saturateWith);
    }

    public static Component getHead(UUID uuid) {
        return ChatHeadUtil.getHead(uuid, null);
    }

    public static String _getHead(UUID uuid, @Nullable String saturateWith) {
        String[] hexColors = ChatHeadUtil.getPixelColors(ChatHeadUtil.getPlayerSkinURL(uuid));
        if (hexColors.length < 64) {
            throw new IllegalArgumentException("Hex colors array must have at least 64 elements.");
        }
        String[][] components = new String[8][8];
        for (int i = 0; i < 64; ++i) {
            int row = i / 8;
            int col = i % 8;
            int unicodeChar = (char)(61440 + i % 8 + 1);
            Object component = "<font:player_head>";
            component = saturateWith == null ? (String)component + String.format("<%s>", hexColors[i]) : (String)component + String.format("<%s>", ChatHeadUtil.saturateColor(hexColors[i], saturateWith, 0.8));
            component = i != 7 && i != 15 && i != 23 && i != 31 && i != 39 && i != 47 && i != 55 ? (i == 63 ? (String)component + String.format("%s", Character.valueOf((char)unicodeChar)) : (String)component + String.format("%s%s", Character.valueOf((char)unicodeChar), "\uf102")) : (String)component + String.format("%s%s", Character.valueOf((char)unicodeChar), "\uf101");
            components[row][col] = component;
        }
        StringBuilder componentToReturn = new StringBuilder();
        for (String[] c : components) {
            int var10 = c.length;
            for (String cc : c) {
                componentToReturn.append(cc);
            }
        }
        return componentToReturn.toString();
    }

    public static Component getHead(UUID uuid, @Nullable String saturateWith) {
        String[] hexColors = ChatHeadUtil.getPixelColors(ChatHeadUtil.getPlayerSkinURL(uuid));
        if (hexColors.length < 64) {
            throw new IllegalArgumentException("Hex colors array must have at least 64 elements.");
        }
        Component[][] components = new Component[8][8];
        for (int i = 0; i < 64; ++i) {
            int row = i / 8;
            int col = i % 8;
            int unicodeChar = (char)(61440 + i % 8 + 1);
            TextComponent component = Component.empty();
            component = i != 7 && i != 15 && i != 23 && i != 31 && i != 39 && i != 47 && i != 55 ? (i == 63 ? component.append(MiniMessageUtil.deserialize("%s", Character.valueOf((char)unicodeChar))) : component.append(MiniMessageUtil.deserialize("%s%s", Character.valueOf((char)unicodeChar), "\uf102"))) : component.append(MiniMessageUtil.deserialize("%s%s", Character.valueOf((char)unicodeChar), "\uf101"));
            component = saturateWith == null ? component.color(TextColor.fromHexString((String)hexColors[i])) : component.color(TextColor.fromHexString((String)ChatHeadUtil.saturateColor(hexColors[i], saturateWith, 0.8)));
            component = component.font(Key.key((String)"player_head"));
            components[row][col] = component;
        }
        TextComponent componentToReturn = Component.empty();
        for (Component[] c : components) {
            int var10 = c.length;
            for (Component cc : c) {
                componentToReturn = componentToReturn.append(cc);
            }
        }
        return componentToReturn;
    }

    private static String[] getPixelColors(String playerSkinUrl) {
        String[] colors = new String[64];
        try {
            BufferedImage skinImage = ImageIO.read(new URL(playerSkinUrl));
            int faceStartX = 8;
            int faceStartY = 8;
            int faceWidth = 8;
            int faceHeight = 8;
            BufferedImage faceImage = skinImage.getSubimage(faceStartX, faceStartY, faceWidth, faceHeight);
            int index = 0;
            for (int x = 0; x < faceHeight; ++x) {
                for (int y = 0; y < faceWidth; ++y) {
                    int rgb = faceImage.getRGB(x, y);
                    String hexColor = String.format("#%06X", rgb & 0xFFFFFF);
                    colors[index++] = hexColor;
                }
            }
        }
        catch (IOException var13) {
            var13.printStackTrace();
        }
        return colors;
    }

    private static String getPlayerSkinURL(UUID uuid) {
        try {
            String line;
            if (cachedSkinUrls.containsKey(uuid)) {
                return cachedSkinUrls.get(uuid);
            }
            URL url = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid.toString());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            reader.close();
            String jsonResponse = response.toString();
            JSONObject jsonObject = new JSONObject(jsonResponse);
            JSONArray propertiesArray = jsonObject.getJSONArray("properties");
            for (int i = 0; i < propertiesArray.length(); ++i) {
                JSONObject property = propertiesArray.getJSONObject(i);
                if (!property.getString("name").equals("textures")) continue;
                String value = property.getString("value");
                byte[] decodedBytes = Base64.getDecoder().decode(value);
                String decodedValue = new String(decodedBytes);
                JSONObject textureJson = new JSONObject(decodedValue);
                String skinURL = textureJson.getJSONObject("textures").getJSONObject("SKIN").getString("url");
                cachedSkinUrls.put(uuid, skinURL);
                return skinURL;
            }
        }
        catch (Exception var16) {
            var16.printStackTrace();
        }
        return "Unable to retrieve player skin URL.";
    }
}

