/*
 * Decompiled with CFR 0.152.
 */
package to.lodestone.bookshelfapi.api.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import to.lodestone.bookshelfapi.api.kyori.FontInfo;
import to.lodestone.bookshelfapi.api.kyori.Wrap;

public class MiniMessageUtil {
    private static final int CENTER_PX = 154;
    private static final int MAX = 1280;
    private static final Style STYLE = Style.style().font(Key.key((String)"space")).build();
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();

    public static Component deserialize(String str, Object ... args) {
        return MINI_MESSAGE.deserialize((Object)String.format(str, args));
    }

    public static List<Component> deserializeIntoList(String str) {
        ArrayList<Component> components = new ArrayList<Component>();
        for (String line : str.split("\n")) {
            components.add(MiniMessageUtil.deserialize(line, new Object[0]));
        }
        return components;
    }

    public static List<Component> center(String str, Object ... args) {
        return Wrap.of(String.format(str, args), 50).get().stream().map(MiniMessageUtil::getCenteredMessage).map(arg_0 -> ((MiniMessage)MINI_MESSAGE).deserialize(arg_0)).collect(Collectors.toList());
    }

    private static String getCenteredMessage(String str) {
        if (str == null || str.equals("")) {
            return "";
        }
        Component component = MINI_MESSAGE.deserialize((Object)str);
        int messagePxSize = 0;
        boolean previousCode = false;
        ArrayList<Component> individualComponents = new ArrayList<Component>();
        individualComponents.add(component);
        Object nested = component.children();
        while (!nested.isEmpty()) {
            individualComponents.addAll((Collection<Component>)nested);
            nested = ((Component)nested.get(0)).children();
        }
        for (Component child : individualComponents) {
            String message = ((TextComponent)child).content();
            boolean isBold = child.hasDecoration(TextDecoration.BOLD);
            for (char c : message.toCharArray()) {
                if (c == '\u00a7') {
                    previousCode = true;
                    continue;
                }
                if (previousCode) {
                    previousCode = false;
                    isBold = c == 'l' || c == 'L';
                    continue;
                }
                FontInfo dFI = FontInfo.getDefaultFontInfo(c);
                messagePxSize += isBold ? dFI.getBoldLength() : dFI.getLength();
                ++messagePxSize;
            }
        }
        int halvedMessageSize = messagePxSize / 2;
        int toCompensate = 154 - halvedMessageSize;
        int spaceLength = FontInfo.SPACE.getLength() + 1;
        StringBuilder sb = new StringBuilder();
        for (int compensated = 0; compensated < toCompensate; compensated += spaceLength) {
            sb.append(" ");
        }
        return String.valueOf(sb) + str;
    }

    public static Component persistStyle(Component ... components) {
        TextComponent component = Component.empty();
        for (Component comp : components) {
            component = component.append(comp).style(comp.style());
        }
        return component;
    }

    public static TextColor color(String paramString) {
        if (paramString != null) {
            if (TextColor.fromHexString((String)(paramString = paramString.toLowerCase(Locale.ROOT).replace(" ", "_").replace("-", "_"))) != null) {
                return TextColor.fromHexString((String)paramString);
            }
            if (NamedTextColor.NAMES.keys().contains(paramString)) {
                return (TextColor)NamedTextColor.NAMES.value((Object)paramString);
            }
        }
        throw new IllegalArgumentException("Color does not exist: " + (paramString != null ? paramString : "null"));
    }

    public static TextComponent stripFont(Component paramComponent) {
        TextComponent textComponent = MiniMessageUtil.toTextComponent(paramComponent);
        return (TextComponent)((TextComponent.Builder)((TextComponent.Builder)textComponent.toBuilder()).applyDeep(paramComponentBuilder -> paramComponentBuilder.font(null))).build();
    }

    public static TextComponent stripItalic(Component paramComponent) {
        TextComponent textComponent = MiniMessageUtil.toTextComponent(paramComponent);
        return (TextComponent)((TextComponent.Builder)((TextComponent.Builder)textComponent.toBuilder()).applyDeep(paramComponentBuilder -> paramComponentBuilder.decoration(TextDecoration.ITALIC, TextDecoration.State.NOT_SET))).build();
    }

    public static String serialize(Component paramComponent) {
        String str = (String)MINI_MESSAGE.serialize(paramComponent);
        return str.replace("\\<", "<");
    }

    private static TextComponent toTextComponent(Component paramComponent) {
        return (TextComponent)((TextComponent.Builder)Component.text().append(paramComponent)).build();
    }

    public static Component space(int var1) {
        return Component.translatable((String)("space." + Math.min(Math.max(-1280, var1), 1280))).style(STYLE);
    }

    public static Component newLayer() {
        return Component.translatable((String)"newlayer").style(STYLE);
    }
}

