/*
 * Decompiled with CFR 0.152.
 */
package to.lodestone.bookshelfapi.api.util;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\{(.*?)\\}");
    private static final Map<Character, Integer> romanValues = new HashMap<Character, Integer>();

    public static String encodeListToBase64(List<String> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        String joined = String.join((CharSequence)"\n", list);
        return Base64.getEncoder().encodeToString(joined.getBytes(StandardCharsets.UTF_8));
    }

    public static String format(String str, Object ... args) {
        if (str == null || args == null || args.length == 0) {
            return str;
        }
        StringBuilder result = new StringBuilder();
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            int index;
            if (i < length - 2 && str.charAt(i) == '{' && Character.isDigit(str.charAt(i + 1)) && str.charAt(i + 2) == '}' && (index = str.charAt(i + 1) - 48) >= 0 && index < args.length) {
                result.append(args[index]);
                i += 2;
                continue;
            }
            result.append(str.charAt(i));
        }
        return result.toString();
    }

    public static String format(String str, Map<String, Object> values) {
        if (str == null || values == null || values.isEmpty()) {
            return str;
        }
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(str);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String key = matcher.group(1);
            Object value = values.get(key);
            matcher.appendReplacement(result, value != null ? value.toString() : matcher.group(0));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static List<String> decodeBase64ToList(String base64) {
        if (base64 == null || base64.isEmpty()) {
            return List.of();
        }
        byte[] decodedBytes = Base64.getDecoder().decode(base64);
        String decodedString = new String(decodedBytes, StandardCharsets.UTF_8);
        return Arrays.asList(decodedString.split("\n"));
    }

    public static String titleCase(String sentence, boolean removeUnderscore) {
        String[] words;
        StringBuilder titleCaseSentence = new StringBuilder();
        for (String word : words = sentence.toLowerCase().replaceAll("_", removeUnderscore ? " " : "_").split(" ")) {
            if (word.isEmpty()) continue;
            String firstLetter = word.substring(0, 1).toUpperCase();
            String restOfWord = word.substring(1);
            titleCaseSentence.append(firstLetter).append(restOfWord).append(" ");
        }
        return titleCaseSentence.toString().trim();
    }

    public static int romanToInt(String s) {
        int result = 0;
        int prevValue = 0;
        for (int i = s.length() - 1; i >= 0; --i) {
            int value = romanValues.get(Character.valueOf(s.charAt(i)));
            result = value < prevValue ? (result -= value) : (result += value);
            prevValue = value;
        }
        return result;
    }

    public static String intToRoman(int num) {
        if (num < 1 || num > 3999) {
            return String.valueOf(num);
        }
        String[] romanSymbols = new String[]{"I", "IV", "V", "IX", "X", "XL", "L", "XC", "C", "CD", "D", "CM", "M"};
        int[] values = new int[]{1, 4, 5, 9, 10, 40, 50, 90, 100, 400, 500, 900, 1000};
        StringBuilder result = new StringBuilder();
        int i = 12;
        while (num > 0) {
            int quotient = num / values[i];
            num %= values[i];
            while (quotient > 0) {
                result.append(romanSymbols[i]);
                --quotient;
            }
            --i;
        }
        return result.toString();
    }

    private static boolean startsWithVowel(String word) {
        return Pattern.compile("^[aeiou]", 2).matcher(word).find();
    }

    public static double calculateSimilarity(String str1, String str2) {
        int i;
        int[][] dp = new int[str1.length() + 1][str2.length() + 1];
        for (i = 0; i <= str1.length(); ++i) {
            dp[i][0] = i;
        }
        for (int j = 0; j <= str2.length(); ++j) {
            dp[0][j] = j;
        }
        for (i = 1; i <= str1.length(); ++i) {
            for (int j = 1; j <= str2.length(); ++j) {
                dp[i][j] = str1.charAt(i - 1) == str2.charAt(j - 1) ? dp[i - 1][j - 1] : 1 + Math.min(Math.min(dp[i - 1][j], dp[i][j - 1]), dp[i - 1][j - 1]);
            }
        }
        int distance = dp[str1.length()][str2.length()];
        int maxLength = Math.max(str1.length(), str2.length());
        double similarity = 1.0 - (double)distance / (double)maxLength;
        return similarity * 100.0;
    }

    public static String getTimeDuration(int totalSeconds) {
        int hours = totalSeconds / 3600;
        int minutes = totalSeconds % 3600 / 60;
        int seconds = totalSeconds % 60;
        String formattedTime = hours > 0 ? String.format("%02d:%02d:%02d", hours, minutes, seconds) : String.format("%02d:%02d", minutes, seconds);
        return formattedTime;
    }

    public static String getTimeString(long milliseconds) {
        if (milliseconds < 0L) {
            return "Invalid time";
        }
        long seconds = milliseconds / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        if (hours > 0L) {
            long remainingMinutes = minutes % 60L;
            return hours + " hour" + (hours > 1L ? "s" : "") + (String)(remainingMinutes > 0L ? " and " + remainingMinutes + " minute" + (remainingMinutes > 1L ? "s" : "") : "");
        }
        if (minutes > 0L) {
            long remainingSeconds = seconds % 60L;
            return minutes + " minute" + (minutes > 1L ? "s" : "") + (String)(remainingSeconds > 0L ? " and " + remainingSeconds + " second" + (remainingSeconds > 1L ? "s" : "") : "");
        }
        return seconds + " second" + (seconds != 1L ? "s" : "");
    }

    static {
        romanValues.put(Character.valueOf('I'), 1);
        romanValues.put(Character.valueOf('V'), 5);
        romanValues.put(Character.valueOf('X'), 10);
        romanValues.put(Character.valueOf('L'), 50);
        romanValues.put(Character.valueOf('C'), 100);
        romanValues.put(Character.valueOf('D'), 500);
        romanValues.put(Character.valueOf('M'), 1000);
    }
}

