/*
 * Decompiled with CFR 0.152.
 */
package to.lodestone.bookshelfapi.api.util;

import java.io.File;
import java.util.Random;
import net.kyori.adventure.util.TriState;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.java.JavaPlugin;
import org.codehaus.plexus.util.FileUtils;
import org.jetbrains.annotations.NotNull;

public class WorldUtil {
    public static World createWorld(String worldName) {
        return new WorldCreator(worldName).environment(World.Environment.NORMAL).generateStructures(false).hardcore(false).type(WorldType.FLAT).keepSpawnLoaded(TriState.FALSE).createWorld();
    }

    public static World createFlatWorld(String worldName) {
        return new WorldCreator(worldName).environment(World.Environment.NORMAL).generateStructures(false).hardcore(false).type(WorldType.FLAT).keepSpawnLoaded(TriState.FALSE).createWorld();
    }

    public static World createVoidWorld(String worldName) {
        World world = new WorldCreator(worldName).environment(World.Environment.NORMAL).generateStructures(false).generator((ChunkGenerator)new VoidGenerator()).hardcore(false).type(WorldType.FLAT).keepSpawnLoaded(TriState.FALSE).createWorld();
        assert (world != null);
        world.setGameRule(GameRule.ANNOUNCE_ADVANCEMENTS, (Object)false);
        world.setGameRule(GameRule.DO_INSOMNIA, (Object)false);
        world.setGameRule(GameRule.COMMAND_BLOCK_OUTPUT, (Object)false);
        world.setGameRule(GameRule.DISABLE_RAIDS, (Object)true);
        world.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
        world.setGameRule(GameRule.DO_FIRE_TICK, (Object)false);
        world.setGameRule(GameRule.MOB_GRIEFING, (Object)false);
        world.setGameRule(GameRule.GLOBAL_SOUND_EVENTS, (Object)false);
        world.setGameRule(GameRule.DO_ENTITY_DROPS, (Object)false);
        world.setGameRule(GameRule.DO_MOB_SPAWNING, (Object)false);
        world.setGameRule(GameRule.DO_WARDEN_SPAWNING, (Object)false);
        world.setGameRule(GameRule.DO_PATROL_SPAWNING, (Object)false);
        world.setGameRule(GameRule.REDUCED_DEBUG_INFO, (Object)true);
        world.setGameRule(GameRule.DO_TRADER_SPAWNING, (Object)false);
        world.setTime(0L);
        world.setSpawnLocation(0, 121, 0);
        return world;
    }

    public static void deleteWorld(JavaPlugin plugin, World world) {
        plugin.getServer().unloadWorld(world, false);
        WorldUtil.deleteWorldFolder(world);
    }

    private static void deleteWorldFolder(World world) {
        if (world == null) {
            return;
        }
        try {
            File worldFolder = new File(world.getWorldFolder().getPath());
            if (worldFolder.exists()) {
                FileUtils.deleteDirectory((File)worldFolder);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class VoidGenerator
    extends ChunkGenerator {
        @NotNull
        public ChunkGenerator.ChunkData generateChunkData(@NotNull World world, @NotNull Random random, int chunkX, int chunkZ, @NotNull ChunkGenerator.BiomeGrid biome) {
            return this.createChunkData(world);
        }
    }
}

