package dev.lolihub.hideplayer.core;

import dev.lolihub.hideplayer.HidePlayer;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_3222;

public class PlayerCapability {
    static class HideFrom {
        boolean systemMessage = false;

        boolean inGame = false;  // tab list, social, target selector, chat, and rendering.

        boolean statusAndQuery = false;
        boolean scoreBoard = false;
    }

    static class Privilege {
        boolean canSeeHiddenPlayer = false;
    }

    HideFrom hideFrom = new HideFrom();
    Privilege privilege = new Privilege();
    class_3222 player;  // Store player instead of uuid, as the player object is needed to check permissions

    public PlayerCapability(class_3222 player) {
        this.player = player;
        this.flush();
    }

    public boolean canSeeHiddenPlayer() {
        return this.privilege.canSeeHiddenPlayer;
    }

    public boolean hideSystemMessage() {
        return this.hideFrom.systemMessage;
    }

    public boolean showInGame() {
        return !this.hideFrom.inGame;
    }

    public boolean showInGame(class_3222 player) {
        return player.method_5845().equals(this.player.method_5845())
                || HidePlayer.getVisibilityManager().getPlayerCapability(player).canSeeHiddenPlayer()
                || this.showInGame();
    }

    public boolean showStatusAndQuery() {
        return !this.hideFrom.statusAndQuery;
    }

    public void flush() {
        if (this.player != null) {
            this.hideFrom.systemMessage = Permissions.check(this.player, "hideplayer.hide.systemmessage");
            this.hideFrom.inGame = Permissions.check(this.player, "hideplayer.hide.ingame");
            this.hideFrom.statusAndQuery = Permissions.check(this.player, "hideplayer.hide.statusandquery");
            this.hideFrom.scoreBoard = Permissions.check(this.player, "hideplayer.hide.scoreboard");
            this.privilege.canSeeHiddenPlayer = Permissions.check(this.player, "hideplayer.privilege.seehiddenplayer", 2);
        }
        if (this.hideFrom.scoreBoard) {
            HidePlayer.getVisibilityManager().getScoreBoardCache().add(this.player.method_7334().getName());
        } else {
            HidePlayer.getVisibilityManager().getScoreBoardCache().remove(this.player.method_7334().getName());
        }
    }
}
