package dev.lolihub.hideplayer.core;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_3222;

public class VisibilityManager {
    private final Map<class_3222, PlayerCapability> capabilityMap = new ConcurrentHashMap<>();
    private final ScoreBoardCache scoreBoardCache;

    public VisibilityManager() {
        scoreBoardCache = new ScoreBoardCache();
    }

    public void playerLeave(class_3222 player) {
        capabilityMap.remove(player);
    }

    public PlayerCapability getPlayerCapability(class_3222 player) {
        var capability = capabilityMap.get(player);
        if (capability == null) {
            capability = new PlayerCapability(player);
            capabilityMap.put(player, capability);
        }
        return capability;
    }

    public ScoreBoardCache getScoreBoardCache() {
        return scoreBoardCache;
    }
}