package dev.lolihub.hideplayer.mixin;

import dev.lolihub.hideplayer.HidePlayer;
import dev.lolihub.hideplayer.utils.HiddenPlayerKillText;
import dev.lolihub.hideplayer.utils.HiddenPlayerText;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.List;
import net.minecraft.class_1281;
import net.minecraft.class_1282;
import net.minecraft.class_1283;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

@Mixin(class_1283.class)
public class DamageTrackerMixin {
    @Final
    @Shadow
    private class_1309 entity;

    @Shadow @Final private List<class_1281> recentDamage;

    // death message
    @Inject(method = "getDeathMessage", at = @At("RETURN"), cancellable = true)
    private void onGetDeathMessage(CallbackInfoReturnable<class_2561> cir) {
        // death caused by hidden player
        if (!recentDamage.isEmpty()) {
            class_1282 source = recentDamage.getLast().comp_1535();
            class_3222 player = null;
            if (source.method_5526() instanceof class_3222) {
                player = (class_3222) source.method_5526();
            } else if (entity.method_6124() instanceof class_3222) {
                player = (class_3222) entity.method_6124();
            }
            if (player != null && HidePlayer.getVisibilityManager().getPlayerCapability(player).hideSystemMessage()) {
                cir.setReturnValue(new HiddenPlayerKillText(cir.getReturnValue(), entity, player));
            }
        }

        // death of hidden player
        // check this after the above check to avoid hidden player killing hidden player causing leak
        if (entity instanceof class_3222 player2) {
            if (HidePlayer.getVisibilityManager().getPlayerCapability(player2).hideSystemMessage()) {
                cir.setReturnValue(new HiddenPlayerText(cir.getReturnValue(), player2));
            }
        }
    }
}