package dev.lolihub.hideplayer.mixin;

import dev.lolihub.hideplayer.HidePlayer;
import dev.lolihub.hideplayer.utils.HiddenPlayerText;
import net.minecraft.class_2561;
import net.minecraft.class_2985;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(class_2985.class)
public class PlayerAdvancementTrackerMixin {
    @Shadow
    private class_3222 owner;

    // advancement message
    @ModifyArg(
            method = "grantCriterion",  // advancement.value().display().ifPresent lambda
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/server/PlayerManager;broadcast(Lnet/minecraft/text/Text;Z)V"
            )
    )
    private class_2561 modifyAdvancementMessage(class_2561 message) {
        if (HidePlayer.getVisibilityManager().getPlayerCapability(owner).hideSystemMessage()) {
            return new HiddenPlayerText(message, owner);
        }
        return message;
    }
}
