package dev.lolihub.hideplayer.mixin;

import dev.lolihub.hideplayer.HidePlayer;
import net.minecraft.class_2994;
import net.minecraft.class_3364;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(class_3364.class)
public class QueryResponseHandlerMixin {
    // get player count, method 1
    @Redirect(
            method = "handle",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/server/dedicated/DedicatedServer;getCurrentPlayerCount()I"
            )
    )
    private int getFilteredPlayerCount(class_2994 server) {
        if (HidePlayer.getServer() == null) return server.method_3788();
        return (int) HidePlayer.getServer().method_3760().method_14571().stream()
                .filter(player -> HidePlayer.getVisibilityManager()
                        .getPlayerCapability(player)
                        .showStatusAndQuery())
                .count();
    }

    // get player count, in rules reply
    @Redirect(
            method = "createRulesReply",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/server/dedicated/DedicatedServer;getCurrentPlayerCount()I"
            )
    )
    private int getFilteredPlayerCount1(class_2994 server) {
        return getFilteredPlayerCount(server);
    }

    // get player names
    @Redirect(
            method = "createRulesReply",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/server/dedicated/DedicatedServer;getPlayerNames()[Ljava/lang/String;"
            )
    )
    private String[] getFilteredPlayerNames(class_2994 server) {
        if (HidePlayer.getServer() == null) return server.method_3858();
        return HidePlayer.getServer().method_3760().method_14571().stream()
                .filter(player -> HidePlayer.getVisibilityManager()
                        .getPlayerCapability(player)
                        .showStatusAndQuery())
                .map(player -> player.method_7334().getName())
                .toArray(String[]::new);
    }
}