package dev.lolihub.hideplayer.mixin;

import dev.lolihub.hideplayer.utils.Commons;
import net.minecraft.class_2926;
import net.minecraft.class_3246;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(class_3246.class)
public class ServerHandshakeNetworkHandlerMixin {
    // status query
    @Redirect(
            method = "onHandshake",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/server/MinecraftServer;getServerMetadata()Lnet/minecraft/server/ServerMetadata;"
            )
    )
    private class_2926 getServerMetadata(MinecraftServer server) {
        return Commons.getServerMetadata(server);
    }
}
