package dev.lolihub.hideplayer.mixin;

import dev.lolihub.hideplayer.HidePlayer;
import dev.lolihub.hideplayer.events.PlayerLeaveCallback;
import dev.lolihub.hideplayer.utils.Commons;
import dev.lolihub.hideplayer.utils.HiddenPlayerText;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3324;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3244.class)
public class ServerPlayNetworkHandlerMixin {
    @Shadow
    public class_3222 player;

    // player leave event
    @Inject(at = @At(value = "TAIL"), method = "onDisconnected")
    private void onPlayerLeave(CallbackInfo ci) {
        PlayerLeaveCallback.EVENT.invoker().leaveServer(this.player);
    }

    // player leave message
    @ModifyArg(
            method = "onDisconnected",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/server/PlayerManager;broadcast(Lnet/minecraft/text/Text;Z)V"
            )
    )
    private class_2561 onPlayerLeaveBroadcast(class_2561 message) {
        if (HidePlayer.getVisibilityManager().getPlayerCapability(this.player).hideSystemMessage()) {
            return new HiddenPlayerText(message, this.player);
        }
        return message;
    }

    // hat change
//    @Redirect(
//            method = "onClientOptions",
//            at = @At(
//                    value = "INVOKE",
//                    target = "Lnet/minecraft/server/PlayerManager;sendToAll(Lnet/minecraft/network/packet/Packet;)V"
//            )
//    )
//    private void redirectSendToAll(PlayerManager instance, Packet<?> packet) {
//        Commons.redirectSendToAll(instance, packet, this.player);
//    }

    // initialize chat session
    @Redirect(
            method = "method_46366",  // inside setSession()
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/server/PlayerManager;sendToAll(Lnet/minecraft/network/packet/Packet;)V"
            )
    )
    private void redirectSendToAll2(class_3324 instance, class_2596<?> packet) {
        Commons.redirectSendToAll(instance, packet, this.player);
    }
}
