package dev.lolihub.hideplayer.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.mojang.authlib.GameProfile;
import dev.lolihub.hideplayer.HidePlayer;
import dev.lolihub.hideplayer.utils.HiddenPlayerKillText;
import dev.lolihub.hideplayer.utils.HiddenPlayerText;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_5892;
import net.minecraft.class_7648;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3222.class)
public abstract class ServerPlayerEntityMixin extends class_1657 {
    public ServerPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    // all system messages go through this method
    @Inject(method = "sendMessageToClient", at = @At("HEAD"), cancellable = true)
    private void sendMessageToClient(class_2561 message, boolean overlay, CallbackInfo ci, @Local(argsOnly = true) LocalRef<class_2561> messageRef) {
        if (message instanceof HiddenPlayerText) {
            if (((HiddenPlayerText) message)._getPlayerUUID().equals(((class_3222) (Object) this).method_5845())) {
                return;
            }
            if (HidePlayer.getVisibilityManager().getPlayerCapability((class_3222) (Object) this).canSeeHiddenPlayer()) {
                return;
            }
            if (message instanceof HiddenPlayerKillText) {
                messageRef.set(((HiddenPlayerKillText) message)._getGenericText());
                return;
            }
            ci.cancel();
        }
    }

    @Redirect(
            method = "onDeath(Lnet/minecraft/entity/damage/DamageSource;)V",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/server/network/ServerPlayNetworkHandler;sendPacket(Lnet/minecraft/network/packet/Packet;Lnet/minecraft/network/PacketCallbacks;)V"
            )
    )
    private void sendDeathPacket(class_3244 serverPlayNetworkHandler, class_2596<?> packet, class_7648 packetCallbacks, @Local class_2561 text) {
        boolean sendRaw = !(text instanceof HiddenPlayerText);
        if (!sendRaw) {
            if (((HiddenPlayerText) text)._getPlayerUUID().equals(this.method_5845())) sendRaw = true;
        }
        if (!sendRaw) {
            if (HidePlayer.getVisibilityManager().getPlayerCapability((class_3222) (Object) this).canSeeHiddenPlayer())
                sendRaw = true;
        }
        if (sendRaw) {
            serverPlayNetworkHandler.method_14369(packet, packetCallbacks);
            return;
        }
        serverPlayNetworkHandler.method_14369(
                new class_5892(this.method_5628(), ((HiddenPlayerKillText) text)._getGenericText()),
                class_7648.method_45085(
                        () -> new class_5892(
                                this.method_5628(),
                                class_2561.method_43469("death.attack.even_more_magic", this.method_5476()).method_27694(
                                        style -> style.method_10949(new class_2568(
                                                        class_2568.class_5247.field_24342,
                                                        class_2561.method_43469(
                                                                "death.attack.message_too_long",
                                                                class_2561.method_43470(((HiddenPlayerKillText) text)._getGenericText()
                                                                        .method_10858(256)).method_27692(class_124.field_1054)
                                                        )
                                                )
                                        )
                                )
                        )
                )
        );
    }
}
