package dev.lolihub.hideplayer.mixin;

import dev.lolihub.hideplayer.HidePlayer;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_3324;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(class_3225.class)
public class ServerPlayerInteractionManagerMixin {
    @Shadow @Final protected class_3222 player;

    // packet broadcast when game mode change
    @Redirect(
            method = "changeGameMode",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/server/PlayerManager;sendToAll(Lnet/minecraft/network/packet/Packet;)V"
            )
    )
    private void sendGameModeChangePacket(class_3324 instance, class_2596<?> packet) {
        var vm = HidePlayer.getVisibilityManager();
        if (vm.getPlayerCapability(player).showInGame()) {
            instance.method_14581(packet);
        } else {
            for (class_3222 viewer: instance.method_14571()) {
                if (viewer == player || vm.getPlayerCapability(viewer).canSeeHiddenPlayer()) {
                    viewer.field_13987.method_14364(packet);
                }
            }
        }
    }
}
