package dev.lolihub.hideplayer.mixin;

import dev.lolihub.hideplayer.HidePlayer;
import dev.lolihub.hideplayer.utils.Commons;
import net.minecraft.class_2596;
import net.minecraft.class_2757;
import net.minecraft.class_2995;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3324;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(class_2995.class)
public class ServerScoreboardMixin {
    // add scoreboard
    @Redirect(
            method = "addScoreboardObjective",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/server/network/ServerPlayNetworkHandler;sendPacket(Lnet/minecraft/network/packet/Packet;)V"
            )
    )
    private void filterScoreboardPackets(class_3244 instance, class_2596<?> packet) {
        Commons.filterScoreBoardPackets(instance, packet);
    }

    // score update
    @Redirect(
            method = "updateScore",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/server/PlayerManager;sendToAll(Lnet/minecraft/network/packet/Packet;)V"
            )
    )
    private void filterScoreUpdate(class_3324 instance, class_2596<?> packet) {
        var vm = HidePlayer.getVisibilityManager();
        if (packet instanceof class_2757 scorePacket) {
            for (class_3222 viewer : instance.method_14571()) {
                String targetName = scorePacket.method_11862();

                if (targetName.equals(viewer.method_7334().getName())
                        || vm.getPlayerCapability(viewer).canSeeHiddenPlayer()
                        || vm.getScoreBoardCache().checkNoHide(targetName)) {
                    viewer.field_13987.method_14364(packet);
                }
            }
        } else {
            instance.method_14581(packet);
        }
    }
}