package dev.lolihub.hideplayer.mixin;

import dev.lolihub.hideplayer.HidePlayer;
import net.minecraft.class_1297;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets = "net.minecraft.server.world.ThreadedAnvilChunkStorage$EntityTracker")
public class ThreadedAnvilChunkStorageMixin {
    @Final
    @Shadow
    class_1297 entity;

    // Prevents server from sending entity spawn packet to players who shouldn't see the player. This solves the issue of leaking player's UUID.
    @Inject(
            at = @At("HEAD"),
            method = "updateTrackedStatus(Lnet/minecraft/server/network/ServerPlayerEntity;)V",
            cancellable = true
    )
    private void onUpdateTrackedStatus(class_3222 player, CallbackInfo ci) {
        if (player != entity && entity instanceof class_3222 &&
                !HidePlayer.getVisibilityManager().getPlayerCapability((class_3222) entity).showInGame(player)) {
            ci.cancel();
        }
    }
}
