package dev.lolihub.hideplayer.utils;

import dev.lolihub.hideplayer.HidePlayer;
import net.minecraft.class_1657;
import net.minecraft.class_2596;
import net.minecraft.class_2703;
import net.minecraft.class_2757;
import net.minecraft.class_2926;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;
import java.util.Optional;

public class Commons {
    public static void filterScoreBoardPackets(class_3244 instance, class_2596<?> packet) {
        if (packet instanceof class_2757 scorePacket) {
            class_3222 viewer = instance.method_32311();
            String targetName = scorePacket.method_11862();

            if (targetName.equals(viewer.method_7334().getName())
                    || HidePlayer.getVisibilityManager().getPlayerCapability(viewer).canSeeHiddenPlayer()
                    || HidePlayer.getVisibilityManager().getScoreBoardCache().checkNoHide(targetName)) {
                instance.method_14364(packet);
            }
        } else {
            instance.method_14364(packet);
        }
    }

    public static class_2926 getServerMetadata(MinecraftServer server) {
        var vm = HidePlayer.getVisibilityManager();
        class_2926 metadata = server.method_3765();
        if (metadata == null) return null;
        var players = server.method_3760().method_14571().stream().filter(
                p -> vm.getPlayerCapability(p).showStatusAndQuery()).toList();
        // pick first min(12, len(players)) players and shuffle them
        var list = players.stream().map(class_1657::method_7334).limit(12).sorted((a, b) -> (int) (Math.random() * 3) - 1).toList();
        return new class_2926(
                metadata.comp_1273(),
                Optional.of(new class_2926.class_2927(server.method_3760().method_14592(), players.size(), list)),
                metadata.comp_1275(),
                metadata.comp_1276(),
                metadata.comp_1277()
        );
    }

    public static void redirectSendToAll(class_3324 instance, class_2596<?> packet, class_3222 player) {
        assert packet instanceof class_2703;
        var vm = HidePlayer.getVisibilityManager();
        if (vm.getPlayerCapability(player).showInGame()) {
            instance.method_14581(packet);
        } else {
            for (class_3222 p : instance.method_14571()) {
                if (vm.getPlayerCapability(p).canSeeHiddenPlayer()) {
                    p.field_13987.method_14364(packet);
                }
            }
            player.field_13987.method_14364(packet);
        }
    }
}
