/*
 * Decompiled with CFR 0.152.
 */
package dev.lolihub.hideplayer.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;

public class ScoreBoardCache {
    private static final File cacheFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "hideplayer.cache");
    private final Set<String> scoreBoardHiddenCache = new HashSet<String>();

    public ScoreBoardCache() {
        if (cacheFile.exists() && cacheFile.isFile() && cacheFile.canRead() && cacheFile.canWrite()) {
            try (Scanner reader = new Scanner(cacheFile);){
                while (reader.hasNextLine()) {
                    String next = reader.nextLine();
                    if (next.isBlank()) continue;
                    this.scoreBoardHiddenCache.add(next);
                }
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean checkNoHide(String playerName) {
        return !this.scoreBoardHiddenCache.contains(playerName);
    }

    public void add(String playerName) {
        this.scoreBoardHiddenCache.add(playerName);
    }

    public void remove(String playerName) {
        this.scoreBoardHiddenCache.remove(playerName);
    }

    public void save() {
        try (FileWriter writer = new FileWriter(cacheFile);){
            for (String playerName : this.scoreBoardHiddenCache) {
                writer.write(playerName);
                writer.write(10);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

