/*
 * Decompiled with CFR 0.152.
 */
package com.kingtheguy;

import com.kingtheguy.Config;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class DialMenu
implements Listener {
    ArrayList<PlayerDialMenu> player_with_menu = new ArrayList();
    List<Player> wait_list = new ArrayList<Player>();
    final int bar_size = 55;
    public static TextColor selection_color = Config.default_settings.text_color;

    public Integer getPlayer(Player player) {
        for (PlayerDialMenu p : this.player_with_menu) {
            if (!p.player.equals((Object)player)) continue;
            return this.player_with_menu.indexOf(p);
        }
        return -1;
    }

    public PlayerDialMenu getPlayerDialMenu(Player player) {
        Integer index = this.getPlayer(player);
        if (index > -1) {
            return this.player_with_menu.get(index);
        }
        return null;
    }

    public void closeMenu(Player player) {
        Integer index = this.getPlayer(player);
        if (index != -1) {
            player.removePotionEffect(PotionEffectType.BLINDNESS);
            Audience audience = Audience.audience((Audience[])new Audience[]{player});
            audience.sendActionBar(() -> Component.text((String)""));
            this.player_with_menu.get((int)index.intValue()).all_context = null;
            this.player_with_menu.remove(this.player_with_menu.get(index));
            this.wait_list.remove(player);
            Location location = player.getLocation();
            Bukkit.getWorld((UUID)location.getWorld().getUID()).playSound(location, Sound.BLOCK_CHISELED_BOOKSHELF_PICKUP_ENCHANTED, 1.0f, 0.6f);
        }
    }

    public void removeLastDialMenu(Player player) {
        Integer index = this.getPlayer(player);
        if (index <= -1) {
            return;
        }
        PlayerDialMenu has_menu_open = this.player_with_menu.get(this.getPlayer(player));
        has_menu_open.all_context.remove(has_menu_open.all_context.size() - 1);
        this.sendDialActionBar(player, has_menu_open, false);
        this.refreshDialMenu(player);
    }

    public void openDialMenu(String id, List<String> so, Player player, ItemStack uit) {
        Integer index = this.getPlayer(player);
        if (index == -1) {
            PlayerDialMenu new_player = new PlayerDialMenu();
            new_player.createPlayer(player);
            this.player_with_menu.add(new_player);
        }
        PlayerDialMenu has_menu_open = this.player_with_menu.get(this.getPlayer(player));
        ArrayList<String> new_list = new ArrayList<String>();
        for (int x = 0; x < so.size(); ++x) {
            new_list.add(so.get(x));
        }
        has_menu_open.dial_id = id;
        has_menu_open.dial_options = so;
        has_menu_open.using_item = uit;
        player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 1200, 1).withAmbient(false).withParticles(false));
        has_menu_open.moveDialMenuSelection();
        this.refreshDialMenu(player);
    }

    public void refreshDialMenu(Player player) {
        Integer index = this.getPlayer(player);
        if (index == -1) {
            return;
        }
        PlayerDialMenu has_menu_open = this.player_with_menu.get(index);
        has_menu_open.moveDialMenuSelection();
        this.sendDialActionBar(player, has_menu_open, false);
        boolean hasBlindness = false;
        for (PotionEffect effect : player.getActivePotionEffects()) {
            if (!effect.getType().equals(PotionEffectType.BLINDNESS)) continue;
            hasBlindness = true;
        }
        if (!hasBlindness) {
            this.closeMenu(player);
        }
    }

    public void sendDialActionBar(Player player, PlayerDialMenu p_with_m, boolean as_title) {
        Audience audience = Audience.audience((Audience[])new Audience[]{player});
        if (as_title) {
            audience.showTitle(Title.title((Component)Component.text((String)""), (Component)this.centerTextBar(p_with_m), (Title.Times)Title.Times.times((Duration)Duration.ofSeconds(0L), (Duration)Duration.ofSeconds(1L), (Duration)Duration.ofSeconds(1L))));
            return;
        }
        audience.sendActionBar(() -> this.centerTextBar(p_with_m));
    }

    public Component centerTextBar(PlayerDialMenu has_menu_open) {
        String word;
        int context_bar = 55;
        if (has_menu_open.custom_answer != "") {
            int custom_length = has_menu_open.custom_answer.length();
            if (custom_length > 18) {
                custom_length = 18;
            }
            context_bar = 55 - custom_length;
        }
        if ((word = has_menu_open.hover) == "") {
            word = has_menu_open.dial_options.get(has_menu_open.dial_options.size() / 2);
        }
        int word_size = word.length();
        Object blank_space = new String();
        for (int x = 0; x < context_bar; ++x) {
            blank_space = (String)blank_space + " ";
        }
        String text_bar = String.join((CharSequence)"  ", has_menu_open.dial_options);
        String context = "MAIN";
        int cnt_size = has_menu_open.all_context.size();
        if (cnt_size > 1) {
            context = has_menu_open.all_context.get((int)(cnt_size - 2)).answer;
        }
        if (has_menu_open.last_selection_value == -1) {
            int size = has_menu_open.dial_options.size();
            has_menu_open.last_selection_value = Math.round(size / 2);
        }
        text_bar = String.format("%s%s%s", blank_space, text_bar, blank_space);
        String[] what_we_got = this.spacer(String.join((CharSequence)"  ", has_menu_open.dial_options), word, context_bar);
        if (has_menu_open.custom_answer != "") {
            return ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)has_menu_open.custom_answer).color((TextColor)NamedTextColor.GOLD)).append(Component.text((String)" : ").color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)"< ").color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)what_we_got[0]).color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)this.colorText(has_menu_open.tick, word)).color(selection_color))).append(Component.text((String)what_we_got[1]).color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)" >").color((TextColor)NamedTextColor.GRAY));
        }
        return ((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"< ").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)what_we_got[0]).color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)this.colorText(has_menu_open.tick, word)).color(selection_color))).append(Component.text((String)what_we_got[1]).color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)" >").color((TextColor)NamedTextColor.GRAY));
    }

    public String colorText(int tick, String text) {
        boolean skip_around = false;
        if (skip_around) {
            return "   [ " + text + " ]   ";
        }
        if (tick == 1) {
            return ". .[ " + text + " ]   ";
        }
        if (tick == 2) {
            return "  .[ " + text + " ]   ";
        }
        if (tick == 3) {
            return "   [ " + text + " ]   ";
        }
        if (tick == 4) {
            return "   [ " + text + " ].  ";
        }
        if (tick == 5) {
            return "   [ " + text + " ]. .";
        }
        return text;
    }

    public String[] spacer(String text, String word, int context_bar) {
        Integer word_index = text.indexOf(word);
        Integer word_length = word.length();
        Integer word_half_length = word_length / 2;
        String first = text.substring(0, word_index);
        String last = text.substring(word_index + word_length);
        int x = 0;
        while (first.length() <= context_bar / 2) {
            first = String.format(" %s", first);
            ++x;
        }
        x = 0;
        while (last.length() <= context_bar / 2) {
            last = String.format("%s ", last);
            ++x;
        }
        first = first.substring(first.length() - context_bar / 2, first.length() - 1);
        last = last.substring(1, context_bar / 2);
        String plus = "";
        if (word_length % 2 == 0) {
            plus = " ";
        }
        last = String.format("%s%s", last.substring(0, last.length() - word_half_length), plus);
        return new String[]{first.substring(word_half_length), last};
    }

    public List<String> alphabet() {
        return List.of("a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "-", "'", "#", "_", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "=DEL=", "=DONE=");
    }

    public class PlayerDialMenu {
        Player player;
        String hover;
        String hover_last;
        Integer page;
        float initial_yaw;
        int last_yaw_value;
        int last_selection_value = -1;
        int tick = 0;
        int tick_offset = 3;
        ArrayList<DialContext> all_context = new ArrayList();
        ItemStack using_item;
        List<String> dial_options;
        String dial_id;
        String selection_answer;
        String custom_answer = "";

        public DialContext getListOfContext() {
            return this.all_context.get(this.all_context.size() - 1);
        }

        public void createPlayer(Player the_player) {
            this.player = the_player;
            this.hover = "";
            this.hover_last = "";
            this.initial_yaw = the_player.getLocation().getYaw();
        }

        public void moveDialMenuSelection() {
            int selected;
            Location location = this.player.getLocation();
            int yaw = (int)this.player.getLocation().getYaw();
            if (yaw <= -1) {
                yaw += 361;
            }
            if (String.valueOf(this.last_yaw_value).length() == 3 && String.valueOf(yaw).length() == 1) {
                this.last_yaw_value = yaw;
            }
            if (String.valueOf(this.last_yaw_value).length() == 1 && String.valueOf(yaw).length() == 3) {
                this.last_yaw_value = yaw;
            }
            if ((selected = this.last_selection_value) > this.dial_options.size() - 1) {
                selected = 0;
            }
            boolean sneaking = false;
            if (this.player.isSneaking()) {
                this.tick = this.tick_offset;
                sneaking = true;
            }
            if (yaw > this.last_yaw_value) {
                if (selected < this.dial_options.size() - 1) {
                    Bukkit.getWorld((UUID)location.getWorld().getUID()).playSound(location, Sound.ITEM_SPYGLASS_USE, 0.5f, 1.0f);
                    if (sneaking) {
                        ++selected;
                    } else {
                        ++this.tick;
                    }
                }
            } else if (yaw < this.last_yaw_value && selected > 0) {
                Bukkit.getWorld((UUID)location.getWorld().getUID()).playSound(location, Sound.ITEM_SPYGLASS_USE, 0.5f, 1.0f);
                if (sneaking) {
                    --selected;
                } else {
                    --this.tick;
                }
            }
            if (!sneaking) {
                if (this.tick >= this.tick_offset * 2) {
                    this.tick = 1;
                    if (selected < this.dial_options.size() - 1) {
                        ++selected;
                    }
                } else if (this.tick <= 0) {
                    this.tick = this.tick_offset * 2 - 1;
                    if (selected > 0) {
                        --selected;
                    }
                }
            }
            if (this.last_yaw_value != yaw) {
                this.last_yaw_value = yaw;
            }
            if (selected > -1) {
                this.hover = this.dial_options.get(selected);
            }
            if (this.hover != this.hover_last) {
                this.hover_last = selected <= -1 ? this.dial_options.get(this.dial_options.size() / 2) : this.dial_options.get(selected);
            }
            if (selected != this.last_selection_value) {
                Bukkit.getWorld((UUID)location.getWorld().getUID()).playSound(location, Sound.ITEM_BOOK_PAGE_TURN, 1.0f, 1.0f);
            }
            this.last_selection_value = selected;
        }

        public String getDataFromId() {
            String[] split = this.dial_id.split(":", -1);
            if (split.length <= 2) {
                return split[1];
            }
            return split[2];
        }

        public void playerChooseSelection(PlayerInteractEvent ev) {
            if (DialMenu.this.getPlayer(this.player) > -1) {
                ev.setCancelled(true);
            } else if (ev.getPlayer().getInventory().getItemInMainHand() == null) {
                return;
            }
            Player player = ev.getPlayer();
            for (PlayerDialMenu p : DialMenu.this.player_with_menu) {
                if (!p.player.equals((Object)player)) continue;
                if (p.hover == "NEXT PAGE") {
                    PlayerDialMenu playerDialMenu = p;
                    Integer n = playerDialMenu.page;
                    playerDialMenu.page = playerDialMenu.page + 1;
                    return;
                }
                p.hover = this.hover;
                p.selection_answer = this.hover;
            }
        }
    }

    public class DialContext {
        int id;
        List<String> selection_options;
        String answer = new String();

        public DialContext(DialMenu this$0) {
        }
    }
}

