/*
 * Decompiled with CFR 0.152.
 */
package com.kingtheguy.items;

import com.kingtheguy.magic;
import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class Item_Manager {
    public static ItemStack magic_mirror_book;
    public static ItemStack portalis_book;
    public static ItemStack ender_oil;
    public static ItemStack infused_paper;
    public static ItemStack ripped_page;
    public static ItemStack coin;
    public static Integer portalis_max_uses;

    public static void init() {
        Item_Manager.createMagicMirror();
        Item_Manager.createPortalis();
        Item_Manager.createEnderOil();
        Item_Manager.createInfusedPaper();
        ripped_page = Item_Manager.createRippedWarpPage("SPAWN");
        Item_Manager.createPortalisRecipe();
        Item_Manager.createStoneCutterRecipe();
        Item_Manager.createCoin();
        Item_Manager.changeLodestoneRecipe();
    }

    private static ItemStack getMundanePotion() {
        ItemStack mundane_potion = new ItemStack(Material.POTION);
        PotionMeta mundane_potion_meta = (PotionMeta)mundane_potion.getItemMeta();
        mundane_potion.setItemMeta((ItemMeta)mundane_potion_meta);
        return mundane_potion;
    }

    private static void createCoin() {
        ItemStack item = new ItemStack(Material.GOLD_NUGGET, 1);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(Component.text((String)"Coin").color((TextColor)NamedTextColor.GOLD));
        ArrayList<Component> lore = new ArrayList<Component>();
        lore.add(Component.text((String)String.format("for trading", new Object[0])).color((TextColor)NamedTextColor.YELLOW));
        meta.lore(lore);
        meta.addEnchant(Enchantment.LURE, 1, false);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        item.setItemMeta(meta);
        coin = item;
        NamespacedKey coin_key = new NamespacedKey((Plugin)magic.getPlugin(), "custom_coin");
        ShapelessRecipe recipe = new ShapelessRecipe(coin_key, coin);
        recipe.addIngredient(1, Material.BEDROCK);
        Bukkit.getServer().addRecipe((Recipe)recipe);
        Bukkit.updateRecipes();
    }

    private static void createMagicMirror() {
        ItemStack item = new ItemStack(Material.BOOK, 1);
        ItemMeta meta = item.getItemMeta();
        meta.displayName((Component)Component.text((String)String.format("Magic Mirror", new Object[0])));
        Integer max_uses = 6;
        NamespacedKey key = new NamespacedKey((Plugin)magic.getPlugin(), "magic_mirror_use_data");
        meta.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)0);
        ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
        lore.add(Component.text((String)String.format("%s/%s uses", 0, max_uses)));
        meta.lore(lore);
        meta.addEnchant(Enchantment.LURE, 1, false);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        item.setItemMeta(meta);
        magic_mirror_book = item;
    }

    private static void createPortalis() {
        portalis_book = Item_Manager.refillPortalis(0);
    }

    private static void createMagicMirrorRecipe() {
        NamespacedKey key = new NamespacedKey((Plugin)magic.getPlugin(), "custom_magic_mirror_recipe_LEATHER");
        ShapedRecipe recipe = new ShapedRecipe(key, magic_mirror_book);
        recipe.shape(new String[]{"XXX", "ASD", "XXX"});
        recipe.setIngredient('X', Material.LEATHER);
        recipe.setIngredient('A', Material.GOLD_INGOT);
        recipe.setIngredient('S', Material.ENDER_EYE);
        recipe.setIngredient('D', infused_paper);
        Bukkit.getServer().addRecipe((Recipe)recipe);
        Bukkit.updateRecipes();
        key = new NamespacedKey((Plugin)magic.getPlugin(), "custom_magic_mirror_recipe_HIDE");
        recipe = new ShapedRecipe(key, magic_mirror_book);
        recipe.shape(new String[]{"XXX", "ASD", "XXX"});
        recipe.setIngredient('X', Material.RABBIT_HIDE);
        recipe.setIngredient('A', Material.GOLD_INGOT);
        recipe.setIngredient('S', Material.ENDER_EYE);
        recipe.setIngredient('D', infused_paper);
        Bukkit.getServer().addRecipe((Recipe)recipe);
        Bukkit.updateRecipes();
    }

    private static void createPortalisRecipe() {
        NamespacedKey key = new NamespacedKey((Plugin)magic.getPlugin(), "custom_portalis_recipe_LEATHER");
        ShapedRecipe recipe = new ShapedRecipe(key, portalis_book);
        recipe.shape(new String[]{"XXX", "ASD", "XXX"});
        recipe.setIngredient('X', Material.LEATHER);
        recipe.setIngredient('A', Material.GOLD_INGOT);
        recipe.setIngredient('S', Material.ENDER_EYE);
        recipe.setIngredient('D', infused_paper);
        Bukkit.getServer().addRecipe((Recipe)recipe);
        Bukkit.updateRecipes();
        key = new NamespacedKey((Plugin)magic.getPlugin(), "custom_portalis_recipe_HIDE");
        recipe = new ShapedRecipe(key, portalis_book);
        recipe.shape(new String[]{"XXX", "ASD", "XXX"});
        recipe.setIngredient('X', Material.RABBIT_HIDE);
        recipe.setIngredient('A', Material.GOLD_INGOT);
        recipe.setIngredient('S', Material.ENDER_EYE);
        recipe.setIngredient('D', infused_paper);
        Bukkit.getServer().addRecipe((Recipe)recipe);
        Bukkit.updateRecipes();
    }

    private static void refillMagicMirrorRecipe() {
        ItemStack repaired_book = new ItemStack(magic_mirror_book);
        ItemMeta meta = repaired_book.getItemMeta();
        NamespacedKey m_key = new NamespacedKey((Plugin)magic.getPlugin(), "magic_mirror_use_data");
        meta.getPersistentDataContainer().set(m_key, PersistentDataType.INTEGER, (Object)6);
        Integer max_uses = 6;
        ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
        lore.add(Component.text((String)String.format("%s/%s uses", max_uses, max_uses)));
        meta.lore(lore);
        repaired_book.setItemMeta(meta);
        NamespacedKey key = new NamespacedKey((Plugin)magic.getPlugin(), "custom_magic_mirror_recipe_REFILL");
        ShapelessRecipe recipe = new ShapelessRecipe(key, repaired_book);
        recipe.addIngredient(1, magic_mirror_book);
        recipe.addIngredient(6, infused_paper);
        Bukkit.getServer().addRecipe((Recipe)recipe);
        Bukkit.updateRecipes();
    }

    public static ItemStack refillPortalis(Integer amount) {
        ItemStack item = new ItemStack(Material.BOOK, 1);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(Component.text((String)String.format("Portalis", new Object[0])).color((TextColor)NamedTextColor.GOLD));
        NamespacedKey key = new NamespacedKey((Plugin)magic.getPlugin(), "portalis_use_data");
        meta.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)amount);
        ArrayList<Component> lore = new ArrayList<Component>();
        lore.add(Component.text((String)String.format("%s/%s uses", amount, portalis_max_uses)).color((TextColor)NamedTextColor.AQUA));
        meta.lore(lore);
        meta.addEnchant(Enchantment.LURE, 1, false);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        item.setItemMeta(meta);
        return item;
    }

    private static void createEnderOil() {
        ItemStack potion = new ItemStack(Material.POTION, 1);
        PotionMeta potion_meta = (PotionMeta)potion.getItemMeta();
        potion_meta.displayName((Component)Component.text((String)String.format("Ender Oil", new Object[0])));
        potion_meta.addEnchant(Enchantment.LURE, 1, false);
        potion_meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        potion.setItemMeta((ItemMeta)potion_meta);
        ender_oil = potion;
    }

    public static ItemStack createRippedWarpPage(String warp_name) {
        ItemStack item = new ItemStack(Material.FILLED_MAP, 1);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(Component.text((String)String.format("Ripped Page", new Object[0])).color((TextColor)NamedTextColor.GOLD));
        NamespacedKey key = new NamespacedKey((Plugin)magic.getPlugin(), "portalis_ripped_page");
        meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)warp_name);
        ArrayList<Component> lore = new ArrayList<Component>();
        lore.add(Component.text((String)String.format("@: %s", warp_name)).color((TextColor)NamedTextColor.YELLOW));
        lore.add(Component.text((String)String.format("..you feel dissy gazing on it.", new Object[0])).color((TextColor)NamedTextColor.DARK_PURPLE));
        lore.add(Component.text((String)String.format("one time use", new Object[0])).color((TextColor)NamedTextColor.AQUA));
        meta.lore(lore);
        meta.addEnchant(Enchantment.LURE, 1, false);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        item.setItemMeta(meta);
        return item;
    }

    private static void createInfusedPaper() {
        ItemStack item = new ItemStack(Material.PAPER, 1);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(Component.text((String)String.format("Infused Paper", new Object[0])).color((TextColor)NamedTextColor.AQUA));
        ArrayList<Component> lore = new ArrayList<Component>();
        lore.add(Component.text((String)String.format("I can see my reflection", new Object[0])).color((TextColor)NamedTextColor.DARK_PURPLE));
        meta.lore(lore);
        meta.addEnchant(Enchantment.LURE, 1, false);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        item.setItemMeta(meta);
        infused_paper = item;
        NamespacedKey key = new NamespacedKey((Plugin)magic.getPlugin(), "custom_infused_paper_recipe");
        ItemStack result = new ItemStack(infused_paper);
        result.setAmount(8);
        ShapedRecipe recipe = new ShapedRecipe(key, result);
        recipe.shape(new String[]{"XXX", "XYX", "XXX"});
        recipe.setIngredient('X', Material.PAPER);
        recipe.setIngredient('Y', ender_oil);
        Bukkit.getServer().addRecipe((Recipe)recipe);
        Bukkit.updateRecipes();
    }

    private static void createStoneCutterRecipe() {
        NamespacedKey key = new NamespacedKey((Plugin)magic.getPlugin(), "mm_stonecutter_cobblestone");
        ItemStack result = new ItemStack(Material.COBBLESTONE);
        StonecuttingRecipe recipe = new StonecuttingRecipe(key, result, Material.STONE);
        Bukkit.getServer().addRecipe((Recipe)recipe);
        Bukkit.updateRecipes();
        key = new NamespacedKey((Plugin)magic.getPlugin(), "mm_stonecutter_gravel");
        result = new ItemStack(Material.GRAVEL);
        recipe = new StonecuttingRecipe(key, result, Material.COBBLESTONE);
        Bukkit.getServer().addRecipe((Recipe)recipe);
        Bukkit.updateRecipes();
        key = new NamespacedKey((Plugin)magic.getPlugin(), "mm_stonecutter_sand");
        result = new ItemStack(Material.SAND);
        recipe = new StonecuttingRecipe(key, result, Material.GRAVEL);
        Bukkit.getServer().addRecipe((Recipe)recipe);
        Bukkit.updateRecipes();
        key = new NamespacedKey((Plugin)magic.getPlugin(), "mm_stonecutter_cobbled_deepslate");
        result = new ItemStack(Material.COBBLED_DEEPSLATE);
        recipe = new StonecuttingRecipe(key, result, Material.DEEPSLATE);
        Bukkit.getServer().addRecipe((Recipe)recipe);
        Bukkit.updateRecipes();
    }

    public static void changeLodestoneRecipe() {
        for (Recipe recipe : Bukkit.getRecipesFor((ItemStack)new ItemStack(Material.LODESTONE))) {
            if (!(recipe instanceof ShapedRecipe)) continue;
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            NamespacedKey key = shapedRecipe.getKey();
            Bukkit.removeRecipe((NamespacedKey)key);
        }
        NamespacedKey key = new NamespacedKey((Plugin)magic.getPlugin(), "portalis_lodestone");
        ShapedRecipe newLodestoneRecipe = new ShapedRecipe(key, new ItemStack(Material.LODESTONE));
        newLodestoneRecipe.shape(new String[]{"DDD", "DSD", "DDD"});
        newLodestoneRecipe.setIngredient('D', Material.CHISELED_STONE_BRICKS);
        newLodestoneRecipe.setIngredient('S', Material.NETHERITE_INGOT);
        Bukkit.getServer().addRecipe((Recipe)newLodestoneRecipe);
    }

    static {
        portalis_max_uses = 8;
    }
}

