/*
 * Decompiled with CFR 0.152.
 */
package com.kingtheguy;

import com.destroystokyo.paper.event.server.ServerTickStartEvent;
import com.kingtheguy.Utils;
import com.kingtheguy.items.Item_Manager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.inventory.ItemStack;

public class CauldronBrewing
implements Listener {
    static List<Recipe> mixrecipeList = new ArrayList<Recipe>();
    static double cauldron_radius = 1.0;
    private List<Cauldron> all_cauldrons = new ArrayList<Cauldron>();
    public static int max_uses = 24;
    List<Cauldron> remove_list = new ArrayList<Cauldron>();

    public void recipe(ItemStack first, ItemStack second, ItemStack third, ItemStack last, ItemStack result, boolean bottled, int uses) {
        Recipe new_recipe = new Recipe(this);
        new_recipe.first_ingridient = first;
        new_recipe.second_ingridient = second;
        new_recipe.third_ingridient = third;
        new_recipe.last_item = last;
        new_recipe.resulting_item = result;
        new_recipe.can_be_bottled = bottled;
        new_recipe.result_uses = uses;
        mixrecipeList.add(new_recipe);
    }

    public void init_recipes() {
        this.recipe(new ItemStack(Material.ENDER_PEARL), new ItemStack(Material.SPIDER_EYE), new ItemStack(Material.DANDELION), new ItemStack(Material.PAPER), Item_Manager.infused_paper, true, 6);
        this.recipe(new ItemStack(Material.FEATHER), new ItemStack(Material.PHANTOM_MEMBRANE), new ItemStack(Material.POTATO), new ItemStack(Material.COPPER_BLOCK), new ItemStack(Material.OXIDIZED_COPPER), false, 8);
        this.recipe(new ItemStack(Material.BONE_MEAL), new ItemStack(Material.NETHER_WART), new ItemStack(Material.LILAC), new ItemStack(Material.NETHERRACK), new ItemStack(Material.COBBLESTONE), false, 8);
    }

    private int findCauldron(Location loc) {
        if (this.all_cauldrons.size() <= 0) {
            return -1;
        }
        for (Cauldron c : this.all_cauldrons) {
            if (!c.location.equals((Object)loc)) continue;
            return this.all_cauldrons.indexOf(c);
        }
        return -1;
    }

    private void createCauldron(Location loc) {
        int index = this.findCauldron(loc);
        if (index == -1) {
            Cauldron c = new Cauldron();
            c.location = loc;
            c.mixed = false;
            c.locked_recipe = new Recipe(this);
            this.all_cauldrons.add(c);
        }
    }

    private void ToBeRemoved() {
        for (Cauldron c : this.remove_list) {
            if (c.location.getBlock().getType().equals((Object)Material.WATER_CAULDRON)) {
                c.location.getBlock().setType(Material.CAULDRON);
            }
            this.all_cauldrons.remove(c);
        }
        this.remove_list.clear();
    }

    @EventHandler
    public void onServerStart(ServerLoadEvent event) {
        this.init_recipes();
    }

    @EventHandler
    public void tick(ServerTickStartEvent event) {
        if (this.all_cauldrons.size() > 0) {
            this.ToBeRemoved();
            if (event.getTickNumber() % 6 == 1) {
                for (Cauldron c : this.all_cauldrons) {
                    c.CheckCauldron();
                }
                for (Cauldron c : this.all_cauldrons) {
                    c.CauldronIdleParticles();
                    this.CauldronCheckMixRecipe(c.location);
                    if (!c.mixed.booleanValue()) continue;
                    c.CauldronMixedParticle();
                    this.CauldronCheckResult(c.location);
                }
            }
        }
    }

    @EventHandler
    public void onPlayerConsume(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item.equals((Object)Item_Manager.ender_oil)) {
            Block block = player.getTargetBlockExact(30);
            if (block == null) {
                Audience audience = Audience.audience((Audience[])new Audience[]{player});
                audience.sendActionBar(() -> Component.text((String)"Too Far").color((TextColor)NamedTextColor.RED));
                event.setCancelled(true);
                return;
            }
            player.damage(10.0);
            player.teleportAsync(block.getLocation());
            player.getLocation().getWorld().playSound(player.getLocation(), Sound.ENTITY_SHULKER_TELEPORT, 1.0f, 1.0f);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        Block clicked_block = event.getClickedBlock();
        if (clicked_block != null) {
            Location block_location = clicked_block.getLocation();
            if (player.getInventory().getItemInMainHand().getType().equals((Object)Material.WATER_BUCKET)) {
                if (clicked_block.getType() != Material.CAULDRON) {
                    return;
                }
                Block block_below = Bukkit.getWorld((UUID)block_location.getWorld().getUID()).getBlockAt(block_location.getBlockX(), block_location.getBlockY() - 1, block_location.getBlockZ());
                if (block_below.getType() == Material.CAMPFIRE || block_below.getType() == Material.SOUL_CAMPFIRE) {
                    this.createCauldron(block_location);
                }
            }
        }
    }

    public void CauldronCheckResult(Location location) {
        int index = this.findCauldron(location);
        Cauldron cauldron = this.all_cauldrons.get(index);
        Collection entities = location.getNearbyEntities((double)location.getBlockX(), (double)location.getBlockY(), (double)location.getBlockZ());
        Recipe recipe = cauldron.locked_recipe;
        entities.forEach(entity -> {
            if (entity instanceof Item) {
                Item entity_item = (Item)entity;
                ItemStack item = entity_item.getItemStack();
                if (Utils.get3DDistance(location.getBlockX(), location.getBlockY(), location.getBlockZ(), entity.getLocation().getBlockX(), entity.getLocation().getBlockY(), entity.getLocation().getBlockZ()) > cauldron_radius) {
                    return;
                }
                if (recipe.last_item.isSimilar(item)) {
                    cauldron.CauldronTossIngridient(location);
                    for (int x = 0; x <= item.getAmount(); ++x) {
                        cauldron.CauldronMixUse(recipe, item);
                        item.setAmount(item.getAmount() - 1);
                        if (cauldron.locked_recipe.result_uses < 1) break;
                    }
                    if (item.getAmount() < 1) {
                        entity.remove();
                    }
                }
            }
        });
    }

    public boolean recipeContainsIngridient(ItemStack item) {
        for (Recipe recipe : mixrecipeList) {
            if (recipe.first_ingridient.isSimilar(item)) {
                return true;
            }
            if (recipe.second_ingridient.isSimilar(item)) {
                return true;
            }
            if (recipe.third_ingridient.isSimilar(item)) {
                return true;
            }
            if (!recipe.last_item.isSimilar(item)) continue;
            return true;
        }
        return false;
    }

    public void CauldronCheckMixRecipe(Location location) {
        int index = this.findCauldron(location);
        Cauldron cauldron = this.all_cauldrons.get(index);
        Collection entities = location.getNearbyEntities((double)location.getBlockX(), (double)location.getBlockY(), (double)location.getBlockZ());
        Recipe recipe = cauldron.locked_recipe;
        entities.forEach(entity -> {
            if (entity instanceof Item) {
                Item entity_item = (Item)entity;
                ItemStack item = entity_item.getItemStack();
                if (cauldron.mixed.booleanValue()) {
                    return;
                }
                if (Utils.get3DDistance(location.getBlockX(), location.getBlockY(), location.getBlockZ(), entity.getLocation().getBlockX(), entity.getLocation().getBlockY(), entity.getLocation().getBlockZ()) > cauldron_radius) {
                    return;
                }
                if (!this.recipeContainsIngridient(item)) {
                    if (recipe.resulting_item == null || recipe.resulting_item.isSimilar(item)) {
                        return;
                    }
                    cauldron.CauldronTossIngridient(entity.getLocation());
                    cauldron.CauldronOverflow();
                    cauldron.RemoveCauldron();
                    return;
                }
                if (recipe.first_ingridient == null || recipe.first_ingridient.equals((Object)item)) {
                    recipe.first_ingridient = item;
                    cauldron.CauldronTossIngridient(entity.getLocation());
                    entity.remove();
                    return;
                }
                if (recipe.second_ingridient == null || recipe.second_ingridient.equals((Object)item)) {
                    recipe.second_ingridient = item;
                    cauldron.CauldronTossIngridient(entity.getLocation());
                    entity.remove();
                    return;
                }
                if (recipe.third_ingridient == null || recipe.third_ingridient.equals((Object)item)) {
                    recipe.third_ingridient = item;
                    cauldron.CauldronTossIngridient(entity.getLocation());
                    entity.remove();
                    return;
                }
            }
        });
        if (!cauldron.mixed.booleanValue()) {
            for (int x = 0; x < mixrecipeList.size(); ++x) {
                Recipe mix = mixrecipeList.get(x);
                if (!mix.first_ingridient.equals((Object)recipe.first_ingridient) || !mix.second_ingridient.equals((Object)recipe.second_ingridient) || !mix.third_ingridient.equals((Object)recipe.third_ingridient)) continue;
                cauldron.locked_recipe = new Recipe(this);
                cauldron.locked_recipe.first_ingridient = mix.first_ingridient;
                cauldron.locked_recipe.second_ingridient = mix.second_ingridient;
                cauldron.locked_recipe.third_ingridient = mix.third_ingridient;
                cauldron.locked_recipe.last_item = mix.last_item;
                cauldron.locked_recipe.resulting_item = mix.resulting_item;
                cauldron.locked_recipe.can_be_bottled = mix.can_be_bottled;
                cauldron.locked_recipe.result_uses = mix.result_uses;
                cauldron.CauldronMixComplete();
            }
        }
        if (recipe.first_ingridient != null && recipe.second_ingridient != null && recipe.third_ingridient != null && !cauldron.mixed.booleanValue()) {
            cauldron.CauldronOverflow();
            cauldron.RemoveCauldron();
        }
    }

    private class Recipe {
        ItemStack first_ingridient;
        ItemStack second_ingridient;
        ItemStack third_ingridient;
        ItemStack last_item;
        ItemStack resulting_item;
        boolean can_be_bottled;
        int result_uses;

        private Recipe(CauldronBrewing cauldronBrewing) {
        }
    }

    public class Cauldron {
        Location location;
        Boolean mixed;
        Recipe locked_recipe;

        public void CauldronOverflow() {
            Location top = this.location.clone();
            top.setY(top.getY() + 1.0);
            if (top.getBlock().getType().equals((Object)Material.AIR)) {
                top.getBlock().setType(Material.WATER);
                Levelled level = (Levelled)top.getBlock().getBlockData();
                level.setLevel(3);
                top.getBlock().setBlockData((BlockData)level);
            }
        }

        public void CauldronTossIngridient(Location location) {
            Bukkit.getWorld((UUID)location.getWorld().getUID()).spawnParticle(Particle.EXPLOSION, location.getX(), location.getY() + 0.2, location.getZ(), 0);
            location.getWorld().playSound(location, Sound.BLOCK_BUBBLE_COLUMN_WHIRLPOOL_INSIDE, 1.0f, 0.8f);
        }

        private void RemoveCauldron() {
            CauldronBrewing.this.remove_list.add(this);
        }

        private void CheckCauldron() {
            Block block = this.location.getBlock();
            Block block_below = Bukkit.getWorld((UUID)this.location.getWorld().getUID()).getBlockAt(this.location.getBlockX(), this.location.getBlockY() - 1, this.location.getBlockZ());
            if (block.getType().equals((Object)Material.AIR)) {
                this.RemoveCauldron();
                return;
            }
            if (!block.getType().equals((Object)Material.WATER_CAULDRON)) {
                this.RemoveCauldron();
                return;
            }
            if (!block_below.getType().equals((Object)Material.CAMPFIRE) && !block_below.getType().equals((Object)Material.SOUL_CAMPFIRE)) {
                this.RemoveCauldron();
            }
        }

        public void CauldronIdleParticles() {
            int min = 2;
            int max = 8;
            float x = new Random().nextInt(max - min + 1) + min;
            float z = new Random().nextInt(max - min + 1) + min;
            this.location.getWorld().playSound(this.location, Sound.BLOCK_BUBBLE_COLUMN_UPWARDS_AMBIENT, 1.0f, 0.5f);
            Bukkit.getWorld((UUID)this.location.getWorld().getUID()).spawnParticle(Particle.SPLASH, (double)((float)this.location.getBlockX() + x / 10.0f), (double)(this.location.getBlockY() + 1), (double)((float)this.location.getBlockZ() + z / 10.0f), 0);
        }

        public void CauldronMixedParticle() {
            int min = 2;
            int max = 8;
            float x = new Random().nextInt(max - min + 1) + min;
            float z = new Random().nextInt(max - min + 1) + min;
            float y = new Random().nextInt(max - min + 1) + min;
            Bukkit.getWorld((UUID)this.location.getWorld().getUID()).spawnParticle(Particle.GLOW, (double)((float)this.location.getBlockX() + x / 10.0f), (double)((float)this.location.getBlockY() + (1.0f + y / 10.0f)), (double)((float)this.location.getBlockZ() + z / 10.0f), 0);
        }

        public void CauldronMixComplete() {
            Bukkit.getWorld((UUID)this.location.getWorld().getUID()).spawnParticle(Particle.EXPLOSION, (double)this.location.getBlockX() + 0.5, (double)(this.location.getBlockY() + 1), (double)this.location.getBlockZ() + 0.5, 0);
            this.location.getWorld().playSound(this.location, Sound.BLOCK_BUBBLE_COLUMN_WHIRLPOOL_INSIDE, 1.0f, 0.8f);
            this.mixed = true;
        }

        public void CauldronMixUse(Recipe recipe, ItemStack item) {
            Bukkit.getWorld((UUID)this.location.getWorld().getUID()).spawnParticle(Particle.END_ROD, (double)this.location.getBlockX() + 0.5, (double)this.location.getBlockY() + 1.5, (double)this.location.getBlockZ() + 0.5, 0);
            if (item.isSimilar(this.locked_recipe.last_item)) {
                Location new_location = new Location(this.location.getWorld(), (double)this.location.getBlockX(), (double)(this.location.getBlockY() + 1), (double)this.location.getBlockZ());
                Bukkit.getServer().getWorld(new_location.getWorld().getUID()).dropItem(new_location, recipe.resulting_item);
                --this.locked_recipe.result_uses;
            }
            if (item.getType().equals((Object)Material.GLASS_BOTTLE)) {
                this.locked_recipe.result_uses -= 8;
            }
            if (this.locked_recipe.result_uses < 1) {
                this.RemoveCauldron();
            }
            for (Recipe recipe2 : mixrecipeList) {
            }
        }
    }
}

