/*
 * Decompiled with CFR 0.152.
 */
package com.example.lapistrail;

import com.example.lapistrail.ArrowMarkerBlock;
import com.example.lapistrail.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LapisChalkItem
extends Item {
    public LapisChalkItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        BlockPos clickedPos = context.getClickedPos();
        BlockState clickedState = level.getBlockState(clickedPos);
        Direction face = context.getClickedFace();
        Player player = context.getPlayer();
        if (face == null) {
            face = Direction.UP;
        }
        if (face != Direction.UP) {
            return InteractionResult.PASS;
        }
        if (!clickedState.isCollisionShapeFullBlock((BlockGetter)level, clickedPos)) {
            return InteractionResult.PASS;
        }
        BlockPos placePos = clickedPos.above();
        BlockState existing = level.getBlockState(placePos);
        if (!existing.isAir()) {
            return InteractionResult.PASS;
        }
        Direction facing = player != null ? player.getDirection().getOpposite() : Direction.NORTH;
        BlockState arrowState = (BlockState)((BlockState)((BlockState)((ArrowMarkerBlock)((Object)ModBlocks.LAPIS_ARROW.get())).defaultBlockState().setValue((Property)ArrowMarkerBlock.FACING, (Comparable)facing)).setValue(ArrowMarkerBlock.COLOR, (Comparable)DyeColor.BLUE)).setValue((Property)ArrowMarkerBlock.LIT, (Comparable)Boolean.FALSE);
        level.setBlock(placePos, arrowState, 3);
        level.playSound(null, placePos, SoundEvents.BAMBOO_SAPLING_HIT, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (player != null && !player.getAbilities().instabuild) {
            context.getItemInHand().shrink(1);
        }
        return InteractionResult.CONSUME;
    }
}

