/*
 * Decompiled with CFR 0.152.
 */
package com.example.lapistrail;

import com.example.lapistrail.ArrowMarkerBlock;
import com.example.lapistrail.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="lapistrail", bus=EventBusSubscriber.Bus.GAME)
public class LapisTrailEvents {
    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Item item;
        Level level = event.getLevel();
        if (level.isClientSide()) {
            return;
        }
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        ItemStack stack = player.getItemInHand(hand);
        BlockPos clickedPos = event.getPos();
        BlockState clickedState = level.getBlockState(clickedPos);
        if (clickedState.is((Block)ModBlocks.LAPIS_ARROW.get()) && (stack.is(Items.GLOWSTONE_DUST) || stack.is(Items.GLOW_INK_SAC) || stack.is(Items.GLOW_BERRIES))) {
            if (!((Boolean)clickedState.getValue((Property)ArrowMarkerBlock.LIT)).booleanValue()) {
                BlockState newState = (BlockState)clickedState.setValue((Property)ArrowMarkerBlock.LIT, (Comparable)Boolean.TRUE);
                level.setBlock(clickedPos, newState, 19);
                level.getChunkSource().getLightEngine().checkBlock(clickedPos);
                level.playSound(null, clickedPos, SoundEvents.BAMBOO_SAPLING_HIT, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
            return;
        }
        if (clickedState.is((Block)ModBlocks.LAPIS_ARROW.get()) && (item = stack.getItem()) instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item;
            DyeColor dyeColor = dyeItem.getDyeColor();
            if (clickedState.getValue(ArrowMarkerBlock.COLOR) != dyeColor) {
                BlockState newState = (BlockState)clickedState.setValue(ArrowMarkerBlock.COLOR, (Comparable)dyeColor);
                level.setBlock(clickedPos, newState, 3);
                level.playSound(null, clickedPos, SoundEvents.BAMBOO_SAPLING_HIT, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }
}

