/*
 * Decompiled with CFR 0.152.
 */
package net.onelitefeather.antiredstoneclockremastered.commands;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.feature.pagination.Pagination;
import net.onelitefeather.antiredstoneclockremastered.AntiRedstoneClockRemastered;
import net.onelitefeather.antiredstoneclockremastered.model.RedstoneClock;
import net.onelitefeather.antiredstoneclockremastered.service.api.RedstoneTrackingService;
import org.bukkit.command.CommandSender;
import org.incendo.cloud.annotation.specifier.Greedy;
import org.incendo.cloud.annotations.Argument;
import org.incendo.cloud.annotations.Command;
import org.incendo.cloud.annotations.CommandDescription;
import org.incendo.cloud.annotations.Permission;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DisplayActiveClocksCommand
implements Pagination.Renderer.RowRenderer<RedstoneClock> {
    private final RedstoneTrackingService trackingService;
    private final Pagination.Builder pagination = Pagination.builder().resultsPerPage(4);

    @Inject
    public DisplayActiveClocksCommand(RedstoneTrackingService trackingService) {
        this.trackingService = trackingService;
    }

    @Command(value="arcm display [page]")
    @CommandDescription(value="antiredstoneclockremastered.command.display.description")
    @Permission(value={"antiredstoneclockremastered.command.display"})
    public void displayClocks(CommandSender commandSender, @Greedy @Argument(value="page") Integer page) {
        Pagination<RedstoneClock> build = this.pagination.build(AntiRedstoneClockRemastered.PREFIX, this, this::mapToCommand);
        if (page == null) {
            page = 0;
        }
        build.render(this.trackingService.getRedstoneClocks(), Math.max(1, page)).forEach(arg_0 -> commandSender.sendMessage(arg_0));
    }

    private String mapToCommand(int i) {
        return "/arcm display " + i;
    }

    @Override
    @NotNull
    public Collection<Component> renderRow(@Nullable RedstoneClock redstoneClock, int index) {
        if (redstoneClock == null) {
            return List.of();
        }
        return List.of(redstoneClock.render());
    }
}

