/*
 * Decompiled with CFR 0.152.
 */
package net.onelitefeather.antiredstoneclockremastered.injection;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import net.onelitefeather.antiredstoneclockremastered.api.PlotsquaredSupport;
import net.onelitefeather.antiredstoneclockremastered.api.WorldGuardSupport;
import net.onelitefeather.antiredstoneclockremastered.org.bstats.bukkit.Metrics;
import net.onelitefeather.antiredstoneclockremastered.org.bstats.charts.DrilldownPie;
import net.onelitefeather.antiredstoneclockremastered.org.bstats.charts.SimplePie;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

@Singleton
public class MetricsModule {
    private final Metrics metrics;
    private final PlotsquaredSupport plotsquaredSupport;
    private final WorldGuardSupport worldGuardSupport;
    private final JavaPlugin plugin;

    @Inject
    public MetricsModule(JavaPlugin plugin, PlotsquaredSupport plotsquaredSupport, WorldGuardSupport worldGuardSupport) {
        this.plugin = plugin;
        this.plotsquaredSupport = plotsquaredSupport;
        this.worldGuardSupport = worldGuardSupport;
        this.metrics = new Metrics((Plugin)plugin, 19085);
    }

    public void registerCharts() {
        this.metrics.addCustomChart(new SimplePie("worldguard", this::bstatsWorldGuardVersion));
        this.metrics.addCustomChart(new SimplePie("plotsquared", this::bstatsPlotSquaredVersion));
        this.metrics.addCustomChart(new DrilldownPie("maxcount", this::bstatsMaxCount));
    }

    private Map<String, Map<String, Integer>> bstatsMaxCount() {
        HashMap<String, Map<String, Integer>> map = new HashMap<String, Map<String, Integer>>();
        int count = this.plugin.getConfig().getInt("clock.maxCount");
        Map<String, Integer> entry = Map.of(String.valueOf(count), 1);
        switch (count) {
            case 0: {
                map.put("0 \ud83d\udeab", entry);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                map.put("1-5 \ud83d\ude10", entry);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                map.put("6-10 \ud83d\ude42", entry);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                map.put("11-25 \ud83d\ude0a", entry);
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                map.put("26-50 \ud83d\ude00", entry);
                break;
            }
            default: {
                map.put("50+ \ud83d\ude01", entry);
            }
        }
        return map;
    }

    private String bstatsPlotSquaredVersion() {
        return this.plotsquaredSupport.getVersion();
    }

    private String bstatsWorldGuardVersion() {
        return this.worldGuardSupport.getVersion();
    }
}

