/*
 * Decompiled with CFR 0.152.
 */
package net.onelitefeather.antiredstoneclockremastered.service.tracking;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collection;
import net.onelitefeather.antiredstoneclockremastered.AntiRedstoneClockRemastered;
import net.onelitefeather.antiredstoneclockremastered.model.RedstoneClock;
import net.onelitefeather.antiredstoneclockremastered.service.api.RedstoneClockMiddleware;
import net.onelitefeather.antiredstoneclockremastered.service.api.RedstoneTrackingService;
import net.onelitefeather.antiredstoneclockremastered.service.tracking.ConfigMode;
import org.bukkit.Location;
import org.bukkit.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DelegatedTrackingService
implements RedstoneTrackingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedTrackingService.class);
    private final RedstoneTrackingService staticTrackingService;
    private final RedstoneTrackingService dynamicTrackingService;
    private final AntiRedstoneClockRemastered plugin;

    @Inject
    public DelegatedTrackingService(@Named(value="staticTrackingService") RedstoneTrackingService staticTrackingService, @Named(value="dynamicTrackingService") RedstoneTrackingService dynamicTrackingService, AntiRedstoneClockRemastered plugin) {
        this.staticTrackingService = staticTrackingService;
        this.dynamicTrackingService = dynamicTrackingService;
        this.plugin = plugin;
    }

    @Override
    public boolean isRedstoneClock(RedstoneClockMiddleware.CheckContext context) {
        ConfigMode mode = ConfigMode.getEnum((Configuration)this.plugin.getConfig(), "check.mode", ConfigMode.STATIC);
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case ConfigMode.STATIC -> this.staticTrackingService.isRedstoneClock(context);
            case ConfigMode.DYNAMIC -> this.dynamicTrackingService.isRedstoneClock(context);
        };
    }

    @Override
    public Collection<RedstoneClock> getRedstoneClocks() {
        ArrayList<RedstoneClock> redstoneClocks = new ArrayList<RedstoneClock>(this.dynamicTrackingService.getRedstoneClocks());
        redstoneClocks.addAll(this.staticTrackingService.getRedstoneClocks());
        return redstoneClocks;
    }

    @Override
    public void removeClockByLocation(Location location) {
        this.staticTrackingService.removeClockByLocation(location);
        this.dynamicTrackingService.removeClockByLocation(location);
    }
}

