/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.minecraft.extras;

import java.util.Locale;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.translation.GlobalTranslator;
import org.checkerframework.checker.nullness.qual.NonNull;

final class ComponentHelper {
    public static final Pattern SPECIAL_CHARACTERS_PATTERN = Pattern.compile("[^\\s\\w\\-]");

    private ComponentHelper() {
    }

    public static @NonNull Component highlight(@NonNull Component component, @NonNull TextColor highlightColor) {
        return component.replaceText(config -> {
            config.match(SPECIAL_CHARACTERS_PATTERN);
            config.replacement(match -> match.color(highlightColor));
        });
    }

    public static @NonNull Component repeat(@NonNull Component component, int repetitions) {
        TextComponent.Builder builder = Component.text();
        for (int i = 0; i < repetitions; ++i) {
            builder.append(component);
        }
        return builder.build();
    }

    public static int length(@NonNull Component component) {
        int length = 0;
        if (component instanceof TextComponent) {
            length += ((TextComponent)component).content().length();
        }
        Component translated = GlobalTranslator.render(component, Locale.getDefault());
        for (Component child : translated.children()) {
            length += ComponentHelper.length(child);
        }
        return length;
    }
}

