/*
 * Decompiled with CFR 0.152.
 */
package net.onelitefeather.antiredstoneclockremastered.service;

import com.github.zafarkhaja.semver.Version;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpResponse;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.onelitefeather.antiredstoneclockremastered.AntiRedstoneClockRemastered;
import net.onelitefeather.antiredstoneclockremastered.service.api.SchedulerService;
import net.onelitefeather.antiredstoneclockremastered.utils.Constants;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class UpdateService
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateService.class);
    private static final String DOWNLOAD_URL = "https://hangar.papermc.io/OneLiteFeather/AntiRedstoneClock-Remastered/versions/%s";
    private final HttpClient hangarClient = HttpClient.newBuilder().build();
    private final Version localVersion;
    private final SchedulerService schedulerService;
    private Version remoteVersion;
    private ScheduledTask scheduler;

    @Inject
    public UpdateService(AntiRedstoneClockRemastered antiRedstoneClockRemastered, SchedulerService schedulerService) {
        this.localVersion = Version.parse(antiRedstoneClockRemastered.getPluginMeta().getVersion());
        this.schedulerService = schedulerService;
    }

    @Override
    public void run() {
        Version remoteVersion = this.getNewerVersion();
        if (remoteVersion != null) {
            this.remoteVersion = remoteVersion;
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (!onlinePlayer.isOp() && !onlinePlayer.hasPermission("antiredstoneclockremastered.notify.admin.update")) continue;
                this.notifyPlayer(this.localVersion, remoteVersion, onlinePlayer);
            }
        }
    }

    public void notifyConsole(ComponentLogger logger) {
        if (this.remoteVersion != null && this.remoteVersion.isHigherThan(this.localVersion)) {
            logger.warn((Component)Component.translatable("antiredstoneclockremastered.notify.update.console").arguments(Component.text(this.localVersion.toString()), Component.text(this.remoteVersion.toString()), Component.text(DOWNLOAD_URL.formatted(this.remoteVersion.toString()))));
        }
    }

    public void notifyPlayer(Player player) {
        if (this.remoteVersion != null && this.remoteVersion.isHigherThan(this.localVersion)) {
            this.notifyPlayer(this.localVersion, this.remoteVersion, player);
        }
    }

    private void notifyPlayer(Version localVersion, Version remoteVersion, Player player) {
        player.sendMessage((Component)Component.translatable("antiredstoneclockremastered.notify.update.player").arguments(AntiRedstoneClockRemastered.PREFIX, Component.text(localVersion.toString()), Component.text(remoteVersion.toString())));
    }

    public void schedule() {
        this.scheduler = this.schedulerService.runTaskTimerAsynchronously(scheduledTask -> this.run(), 0L, 216000L);
    }

    @Nullable
    private Version getNewerVersion() {
        try {
            HttpResponse<String> httpResponse = this.hangarClient.send(Constants.LATEST_RELEASE_VERSION_REQUEST, HttpResponse.BodyHandlers.ofString());
            Version remoteVersion = Version.parse(httpResponse.body());
            if (remoteVersion.isHigherThan(this.localVersion)) {
                return remoteVersion;
            }
        }
        catch (IOException | InterruptedException e) {
            LOGGER.error("Something went wrong to check updates", e);
        }
        return null;
    }

    public void shutdown() {
        this.hangarClient.shutdownNow();
        this.scheduler.cancel();
    }
}

