/*
 * Decompiled with CFR 0.152.
 */
package net.onelitefeather.antiredstoneclockremastered.injection;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import net.onelitefeather.antiredstoneclockremastered.listener.ComparatorListener;
import net.onelitefeather.antiredstoneclockremastered.listener.ObserverListener;
import net.onelitefeather.antiredstoneclockremastered.listener.PistonListener;
import net.onelitefeather.antiredstoneclockremastered.listener.PlayerListener;
import net.onelitefeather.antiredstoneclockremastered.listener.RedstoneListener;
import net.onelitefeather.antiredstoneclockremastered.listener.SculkListener;
import net.onelitefeather.antiredstoneclockremastered.service.api.RedstoneClockService;
import net.onelitefeather.antiredstoneclockremastered.utils.CheckTPS;
import org.bukkit.Material;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public final class ListenerModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(PlayerListener.class);
        this.bind(ObserverListener.class);
        this.bind(SculkListener.class);
        this.bind(PistonListener.class);
    }

    private ComparatorListener createComparatorListener(Material material, RedstoneClockService redstoneClockService, CheckTPS checkTPS, Plugin plugin) {
        return new ComparatorListener(material, redstoneClockService, checkTPS, plugin);
    }

    private RedstoneListener createRedstoneListener(Material material, RedstoneClockService redstoneClockService, CheckTPS checkTPS, Plugin plugin) {
        return new RedstoneListener(material, redstoneClockService, checkTPS, plugin);
    }

    public void registerEvents(Injector injector, Plugin plugin) {
        Object listener2;
        Object listener1;
        Object listener;
        Material sculk;
        plugin.getServer().getPluginManager().registerEvents((Listener)injector.getInstance(PlayerListener.class), plugin);
        if (plugin.getConfig().getBoolean("check.observer", true)) {
            plugin.getServer().getPluginManager().registerEvents((Listener)injector.getInstance(ObserverListener.class), plugin);
        }
        if (plugin.getConfig().getBoolean("check.sculk", true) && (sculk = Material.getMaterial((String)"SCULK")) != null) {
            plugin.getServer().getPluginManager().registerEvents((Listener)injector.getInstance(SculkListener.class), plugin);
        }
        if (plugin.getConfig().getBoolean("check.piston", true)) {
            plugin.getServer().getPluginManager().registerEvents((Listener)injector.getInstance(PistonListener.class), plugin);
        }
        if (plugin.getConfig().getBoolean("check.comparator", true)) {
            Material comparator = Material.getMaterial((String)"COMPARATOR");
            if (comparator != null) {
                listener = this.createComparatorListener(comparator, injector.getInstance(RedstoneClockService.class), injector.getInstance(CheckTPS.class), plugin);
                plugin.getServer().getPluginManager().registerEvents((Listener)listener, plugin);
            } else {
                listener1 = this.createComparatorListener(Material.getMaterial((String)"REDSTONE_COMPARATOR_OFF"), injector.getInstance(RedstoneClockService.class), injector.getInstance(CheckTPS.class), plugin);
                listener2 = this.createComparatorListener(Material.getMaterial((String)"REDSTONE_COMPARATOR_ON"), injector.getInstance(RedstoneClockService.class), injector.getInstance(CheckTPS.class), plugin);
                plugin.getServer().getPluginManager().registerEvents((Listener)listener1, plugin);
                plugin.getServer().getPluginManager().registerEvents((Listener)listener2, plugin);
            }
        }
        if (plugin.getConfig().getBoolean("check.redstoneAndRepeater", true)) {
            Material repeater = Material.getMaterial((String)"REPEATER");
            if (repeater != null) {
                listener = this.createRedstoneListener(repeater, injector.getInstance(RedstoneClockService.class), injector.getInstance(CheckTPS.class), plugin);
                plugin.getServer().getPluginManager().registerEvents((Listener)listener, plugin);
            } else {
                listener1 = this.createRedstoneListener(Material.getMaterial((String)"DIODE_BLOCK_ON"), injector.getInstance(RedstoneClockService.class), injector.getInstance(CheckTPS.class), plugin);
                listener2 = this.createRedstoneListener(Material.getMaterial((String)"DIODE_BLOCK_OFF"), injector.getInstance(RedstoneClockService.class), injector.getInstance(CheckTPS.class), plugin);
                plugin.getServer().getPluginManager().registerEvents((Listener)listener1, plugin);
                plugin.getServer().getPluginManager().registerEvents((Listener)listener2, plugin);
            }
        }
    }
}

