/*
 * Decompiled with CFR 0.152.
 */
package net.onelitefeather.antiredstoneclockremastered.listener;

import net.onelitefeather.antiredstoneclockremastered.service.api.RedstoneClockService;
import net.onelitefeather.antiredstoneclockremastered.utils.CheckTPS;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.plugin.Plugin;

public final class ComparatorListener
implements Listener {
    private final Material comparatorMaterial;
    private final RedstoneClockService redstoneClockService;
    private final CheckTPS checkTPS;
    private final FileConfiguration config;

    public ComparatorListener(Material comparatorMaterial, RedstoneClockService redstoneClockService, CheckTPS checkTPS, Plugin plugin) {
        this.comparatorMaterial = comparatorMaterial;
        this.redstoneClockService = redstoneClockService;
        this.checkTPS = checkTPS;
        this.config = plugin.getConfig();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    private void onRedstoneComparatorClock(BlockRedstoneEvent blockRedstoneEvent) {
        if (!this.checkTPS.isTpsOk()) {
            return;
        }
        if (!this.config.getBoolean("check.comparator")) {
            return;
        }
        Block block = blockRedstoneEvent.getBlock();
        Material type = block.getType();
        if (type != this.comparatorMaterial) {
            return;
        }
        if (blockRedstoneEvent.getOldCurrent() != 0) {
            return;
        }
        this.redstoneClockService.checkAndUpdateClockState(block);
    }
}

