/*
 * Decompiled with CFR 0.152.
 */
package net.onelitefeather.antiredstoneclockremastered.service.factory;

import net.onelitefeather.antiredstoneclockremastered.AntiRedstoneClockRemastered;
import net.onelitefeather.antiredstoneclockremastered.api.PlotsquaredSupport;
import net.onelitefeather.antiredstoneclockremastered.api.WorldGuardSupport;
import net.onelitefeather.antiredstoneclockremastered.service.api.NotificationService;
import net.onelitefeather.antiredstoneclockremastered.service.api.RedstoneClockService;
import net.onelitefeather.antiredstoneclockremastered.service.api.RegionService;
import net.onelitefeather.antiredstoneclockremastered.service.factory.FoliaHelper;
import net.onelitefeather.antiredstoneclockremastered.service.impl.BukkitRedstoneClockService;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RedstoneClockServiceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedstoneClockServiceFactory.class);

    private RedstoneClockServiceFactory() {
    }

    @NotNull
    public static RedstoneClockService createService(@NotNull AntiRedstoneClockRemastered plugin, RegionService regionService, PlotsquaredSupport plotsquaredSupport, WorldGuardSupport worldGuardSupport, NotificationService notificationService) {
        if (FoliaHelper.isFolia()) {
            LOGGER.info("Folia detected - using FoliaRedstoneClockService");
            LOGGER.warn("Folia implementation not yet ready, falling back to Bukkit implementation");
        }
        LOGGER.info("Using BukkitRedstoneClockService");
        return new BukkitRedstoneClockService(plugin, regionService, worldGuardSupport, plotsquaredSupport, notificationService);
    }
}

