/*
 * Decompiled with CFR 0.152.
 */
package net.onelitefeather.antiredstoneclockremastered.service.impl;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.onelitefeather.antiredstoneclockremastered.AntiRedstoneClockRemastered;
import net.onelitefeather.antiredstoneclockremastered.api.PlotsquaredSupport;
import net.onelitefeather.antiredstoneclockremastered.api.WorldGuardSupport;
import net.onelitefeather.antiredstoneclockremastered.model.RedstoneClock;
import net.onelitefeather.antiredstoneclockremastered.service.api.NotificationService;
import net.onelitefeather.antiredstoneclockremastered.service.api.RedstoneClockService;
import net.onelitefeather.antiredstoneclockremastered.service.api.RegionService;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BukkitRedstoneClockService
implements RedstoneClockService {
    @NotNull
    private final AntiRedstoneClockRemastered antiRedstoneClockRemastered;
    private final RegionService regionService;
    private final WorldGuardSupport worldGuardSupport;
    private final PlotsquaredSupport plotsquaredSupport;
    private final NotificationService notificationService;
    private int endTimeDelay;
    private int maxClockCount;
    private boolean autoBreakBlock;
    private boolean dropItems;
    private List<String> ignoredWorlds;
    private final ConcurrentHashMap<Location, RedstoneClock> activeClockTesters = new ConcurrentHashMap();
    private final ItemStack SILK_TOUCH_PICKAXE = new ItemStack(Material.DIAMOND_PICKAXE);

    @Inject
    public BukkitRedstoneClockService(@NotNull AntiRedstoneClockRemastered antiRedstoneClockRemastered, RegionService regionService, WorldGuardSupport worldGuardSupport, PlotsquaredSupport plotsquaredSupport, NotificationService notificationService) {
        this.antiRedstoneClockRemastered = antiRedstoneClockRemastered;
        this.endTimeDelay = antiRedstoneClockRemastered.getConfig().getInt("clock.endDelay", 300);
        this.maxClockCount = antiRedstoneClockRemastered.getConfig().getInt("clock.maxCount", 150);
        this.autoBreakBlock = antiRedstoneClockRemastered.getConfig().getBoolean("clock.autoBreak", true);
        this.dropItems = antiRedstoneClockRemastered.getConfig().getBoolean("clock.drop", false);
        this.ignoredWorlds = antiRedstoneClockRemastered.getConfig().getStringList("check.ignoredWorlds");
        this.regionService = regionService;
        this.worldGuardSupport = worldGuardSupport;
        this.plotsquaredSupport = plotsquaredSupport;
        this.notificationService = notificationService;
        this.SILK_TOUCH_PICKAXE.addEnchantment(Enchantment.SILK_TOUCH, 1);
    }

    @Override
    public void checkAndUpdateClockStateWithActiveManual(@NotNull Location location, boolean state) {
        if (this.ignoredWorlds.contains(location.getWorld().getName())) {
            return;
        }
        if (this.worldGuardSupport.isRegionAllowed(location)) {
            return;
        }
        if (this.plotsquaredSupport.isAllowedPlot(location)) {
            return;
        }
        RedstoneClock clock = this.getClockByLocation(location);
        if (clock != null) {
            if (clock.isActive()) {
                if (clock.isTimeOut()) {
                    this.removeClockByClock(clock);
                    return;
                }
                if (clock.getTriggerCount() >= this.maxClockCount) {
                    this.destroyRedstoneClock(location, clock);
                    return;
                }
                clock.incrementTriggerCount();
                clock.setActive(false);
                return;
            }
            clock.setActive(state);
        }
        this.addRedstoneClockTest(location);
    }

    @Override
    public void checkAndUpdateClockStateWithActiveManual(@NotNull Block block, boolean state) {
        this.checkAndUpdateClockStateWithActiveManual(block.getLocation(), state);
    }

    @Override
    public void checkAndUpdateClockStateWithActive(@NotNull Block block) {
        this.checkAndUpdateClockStateWithActive(block.getLocation());
    }

    @Override
    public void checkAndUpdateClockStateWithActive(@NotNull Location location) {
        if (this.ignoredWorlds.contains(location.getWorld().getName())) {
            return;
        }
        if (this.worldGuardSupport.isRegionAllowed(location)) {
            return;
        }
        if (this.plotsquaredSupport.isAllowedPlot(location)) {
            return;
        }
        RedstoneClock clock = this.getClockByLocation(location);
        if (clock != null) {
            if (clock.isActive()) {
                if (clock.isTimeOut()) {
                    this.removeClockByClock(clock);
                    return;
                }
                if (clock.getTriggerCount() >= this.maxClockCount) {
                    this.destroyRedstoneClock(location, clock);
                    return;
                }
                clock.incrementTriggerCount();
                clock.setActive(false);
                return;
            }
            clock.setActive(true);
        }
        this.addRedstoneClockTest(location);
    }

    @Override
    public void checkAndUpdateClockState(@NotNull Block block) {
        this.checkAndUpdateClockState(block.getLocation());
    }

    @Override
    public void checkAndUpdateClockState(@NotNull Location location) {
        if (this.ignoredWorlds.contains(location.getWorld().getName())) {
            return;
        }
        if (this.worldGuardSupport.isRegionAllowed(location)) {
            return;
        }
        if (this.plotsquaredSupport.isAllowedPlot(location)) {
            return;
        }
        RedstoneClock clock = this.getClockByLocation(location);
        if (clock != null) {
            if (clock.isTimeOut()) {
                this.removeClockByClock(clock);
                return;
            }
            if (clock.getTriggerCount() >= this.maxClockCount) {
                this.destroyRedstoneClock(location, clock);
                return;
            }
            clock.incrementTriggerCount();
            return;
        }
        this.addRedstoneClockTest(location);
    }

    private void destroyRedstoneClock(@NotNull Location location, @NotNull RedstoneClock clock) {
        if (this.autoBreakBlock) {
            this.breakBlock(location);
        }
        if (!clock.isDetected()) {
            clock.setDetected(true);
            this.notificationService.sendNotificationMessage(location);
        }
        this.removeClockByClock(clock);
    }

    private void breakBlock(@NotNull Location location) {
        Block block = location.getBlock();
        if (this.dropItems) {
            Collection drops = block.getDrops(this.SILK_TOUCH_PICKAXE);
            drops.forEach(itemStack -> block.getWorld().dropItem(location, itemStack));
        }
        Runnable removeTask = () -> block.setType(Material.AIR, true);
        if (this.regionService.isRegionOwner(location)) {
            this.regionService.executeInRegion(location, removeTask);
        }
    }

    @Override
    public void addRedstoneClockTest(@NotNull Location location) {
        this.activeClockTesters.putIfAbsent(location, new RedstoneClock(location, System.currentTimeMillis() / 1000L + (long)this.endTimeDelay));
    }

    @Override
    public void reload() {
        this.antiRedstoneClockRemastered.reloadConfig();
        this.endTimeDelay = this.antiRedstoneClockRemastered.getConfig().getInt("clock.endDelay", 300);
        this.maxClockCount = this.antiRedstoneClockRemastered.getConfig().getInt("clock.maxCount", 150);
        this.autoBreakBlock = this.antiRedstoneClockRemastered.getConfig().getBoolean("clock.autoBreak", true);
        this.dropItems = this.antiRedstoneClockRemastered.getConfig().getBoolean("clock.drop", false);
        this.ignoredWorlds = this.antiRedstoneClockRemastered.getConfig().getStringList("check.ignoredWorlds");
    }

    @Override
    public void removeClockByLocation(@NotNull Location location) {
        this.activeClockTesters.remove(location);
    }

    @Override
    public void removeClockByClock(@NotNull RedstoneClock redstoneClock) {
        this.removeClockByLocation(redstoneClock.getLocation());
    }

    @Override
    public boolean containsLocation(@NotNull Location location) {
        return this.activeClockTesters.containsKey(location);
    }

    @Override
    @Nullable
    public RedstoneClock getClockByLocation(@NotNull Location location) {
        return this.activeClockTesters.get(location);
    }

    @Override
    @NotNull
    public Collection<RedstoneClock> getRedstoneClocks() {
        return Collections.unmodifiableCollection(this.activeClockTesters.values());
    }

    @Override
    @NotNull
    public Collection<Location> getRedstoneClockLocations() {
        return Collections.unmodifiableCollection(this.activeClockTesters.keySet());
    }

    @Override
    @NotNull
    public Map<Location, RedstoneClock> getActiveTester() {
        return Map.copyOf(this.activeClockTesters);
    }
}

