/*
 * Decompiled with CFR 0.152.
 */
package net.onelitefeather.antiredstoneclockremastered.service.impl;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.onelitefeather.antiredstoneclockremastered.AntiRedstoneClockRemastered;
import net.onelitefeather.antiredstoneclockremastered.service.api.NotificationService;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConsoleNotificationService
implements NotificationService {
    private final AntiRedstoneClockRemastered plugin;
    private final NotificationService notificationService;

    public ConsoleNotificationService(@NotNull AntiRedstoneClockRemastered plugin, @Nullable NotificationService notificationService) {
        this.plugin = plugin;
        this.notificationService = notificationService;
    }

    @Override
    public Component getNotificationMessage(@NotNull Location location) {
        return MiniMessage.miniMessage().deserialize("Redstone Clock detected at: X,Y,Z(<x>,<y>,<z>)", new TagResolver[]{Placeholder.component((String)"x", (ComponentLike)Component.text(location.x())), Placeholder.component((String)"y", (ComponentLike)Component.text(location.y())), Placeholder.component((String)"z", (ComponentLike)Component.text(location.z()))});
    }

    @Override
    public void sendNotificationMessage(@NotNull Location location) {
        if (this.notificationService != null) {
            this.notificationService.sendNotificationMessage(location);
        }
        if (!this.isEnabled()) {
            return;
        }
        Bukkit.getConsoleSender().sendMessage(this.getNotificationMessage(location));
    }

    @Override
    public boolean isEnabled() {
        return this.plugin.getConfig().getBoolean("clock.notifyConsole", true) || this.plugin.getConfig().getStringList("notification.enabled").contains("console");
    }
}

