/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.feature.pagination;

import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.feature.pagination.Pagination;
import net.kyori.adventure.text.feature.pagination.PaginationImpl;
import net.kyori.adventure.text.format.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

final class PaginationBuilder
implements Pagination.Builder {
    private int width = 55;
    private int resultsPerPage = 6;
    private char lineCharacter = (char)45;
    private Style lineStyle = Pagination.LINE_STYLE;
    private Pagination.Renderer renderer = Pagination.DEFAULT_RENDERER;
    private char previousPageButtonCharacter = (char)171;
    private Style previousPageButtonStyle = Pagination.PREVIOUS_PAGE_BUTTON_STYLE;
    private char nextPageButtonCharacter = (char)187;
    private Style nextPageButtonStyle = Pagination.NEXT_PAGE_BUTTON_STYLE;

    PaginationBuilder() {
    }

    @Override
    public @NotNull Pagination.Builder width(int width) {
        this.width = width;
        return this;
    }

    @Override
    public @NotNull Pagination.Builder resultsPerPage(@Range(from=0L, to=0x7FFFFFFFL) int resultsPerPage) {
        this.resultsPerPage = resultsPerPage;
        return this;
    }

    @Override
    public @NotNull Pagination.Builder renderer(@NotNull Pagination.Renderer renderer) {
        this.renderer = renderer;
        return this;
    }

    @Override
    public @NotNull Pagination.Builder line(@NotNull Consumer<Pagination.Builder.CharacterAndStyle> line) {
        line.accept(new Pagination.Builder.CharacterAndStyle(){

            @Override
            @NotNull
            public Pagination.Builder.CharacterAndStyle character(char character) {
                PaginationBuilder.this.lineCharacter = character;
                return this;
            }

            @Override
            @NotNull
            public Pagination.Builder.CharacterAndStyle style(@NotNull Style style) {
                PaginationBuilder.this.lineStyle = style;
                return this;
            }
        });
        return this;
    }

    @Override
    public @NotNull Pagination.Builder previousButton(@NotNull Consumer<Pagination.Builder.CharacterAndStyle> previousButton) {
        previousButton.accept(new Pagination.Builder.CharacterAndStyle(){

            @Override
            @NotNull
            public Pagination.Builder.CharacterAndStyle character(char character) {
                PaginationBuilder.this.previousPageButtonCharacter = character;
                return this;
            }

            @Override
            @NotNull
            public Pagination.Builder.CharacterAndStyle style(@NotNull Style style) {
                PaginationBuilder.this.previousPageButtonStyle = style;
                return this;
            }
        });
        return this;
    }

    @Override
    public @NotNull Pagination.Builder nextButton(@NotNull Consumer<Pagination.Builder.CharacterAndStyle> nextButton) {
        nextButton.accept(new Pagination.Builder.CharacterAndStyle(){

            @Override
            @NotNull
            public Pagination.Builder.CharacterAndStyle character(char character) {
                PaginationBuilder.this.nextPageButtonCharacter = character;
                return this;
            }

            @Override
            @NotNull
            public Pagination.Builder.CharacterAndStyle style(@NotNull Style style) {
                PaginationBuilder.this.nextPageButtonStyle = style;
                return this;
            }
        });
        return this;
    }

    @Override
    @NotNull
    public <T> Pagination<T> build(@NotNull Component title, @NotNull Pagination.Renderer.RowRenderer<T> rowRenderer, @NotNull Pagination.PageCommandFunction pageCommand) {
        return new PaginationImpl<T>(this.width, this.resultsPerPage, this.renderer, this.lineCharacter, this.lineStyle, this.previousPageButtonCharacter, this.previousPageButtonStyle, this.nextPageButtonCharacter, this.nextPageButtonStyle, title, rowRenderer, pageCommand);
    }
}

